/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.commons;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.test4j.Logger;
import org.test4j.tools.commons.ClazzHelper;
import org.test4j.tools.commons.IOUtils;
import org.test4j.tools.commons.StringHelper;
import org.test4j.tools.cpdetector.CodePageDetector1Proxy;
import org.test4j.tools.cpdetector.JChardetFacade;

public class ResourceHelper {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFromStream(InputStream is, String encoding) {
        String line = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, encoding));){
            StringBuilder buffer = new StringBuilder();
            boolean isFirst = true;
            while ((line = reader.readLine()) != null) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append("\n");
                }
                buffer.append(line);
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readFromStream(InputStream is) {
        String encoding = ResourceHelper.getFileEncodingCharset(is);
        String context = ResourceHelper.readFromStream(is, encoding);
        return context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] readLinesFromStream(InputStream is, String encoding) {
        String line = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, encoding));){
            ArrayList<String> list = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
            String[] stringArray = list.toArray(new String[0]);
            return stringArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] readLinesFromStream(InputStream is) {
        String encoding = ResourceHelper.getFileEncodingCharset(is);
        String[] lines = ResourceHelper.readLinesFromStream(is, encoding);
        return lines;
    }

    public static void writeStringToFile(File file, String content) {
        ResourceHelper.mkFileParentDir(file);
        try (FileWriter writer = new FileWriter(file, false);){
            writer.write(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyClassPathResource(String classPathResourceName, String fileSystemResourceName) {
        ResourceHelper.copyClassPathResource(classPathResourceName, new File(fileSystemResourceName));
    }

    public static void copyClassPathResource(String classPathResourceName, File fileSystemResourceFile) {
        ResourceHelper.mkFileParentDir(fileSystemResourceFile);
        ClassLoader loader = ResourceHelper.class.getClassLoader();
        try (InputStream resourceInputStream = loader.getResourceAsStream(classPathResourceName);
             FileOutputStream fileOutputStream = new FileOutputStream(fileSystemResourceFile);){
            IOUtils.copy(resourceInputStream, (OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String defaultFileEncoding() {
        String encoding = System.getProperty("file.encoding", "utf-8");
        return encoding;
    }

    public static String getFileEncodingCharset(File file) {
        CodePageDetector1Proxy detector = CodePageDetector1Proxy.getInstance();
        detector.add(JChardetFacade.getInstance());
        try {
            Charset charset;
            try {
                charset = detector.detectCodePage(file.toURL());
            }
            catch (IllegalArgumentException e) {
                charset = Charset.forName(ResourceHelper.defaultFileEncoding());
                Logger.warn((Object)("get file encoding error:" + e.getMessage() + ", use default encoding:" + ResourceHelper.defaultFileEncoding()), (Throwable[])new Throwable[0]);
            }
            String fileCharacterEnding = charset.name();
            return fileCharacterEnding;
        }
        catch (FileNotFoundException ue) {
            throw new RuntimeException(ue.getMessage(), ue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResourceHelper.defaultFileEncoding();
        }
    }

    public static String getFileEncodingCharset(InputStream is) {
        CodePageDetector1Proxy detector = CodePageDetector1Proxy.getInstance();
        detector.add(JChardetFacade.getInstance());
        try {
            Charset charset;
            Charset.forName(ResourceHelper.defaultFileEncoding());
            try {
                charset = detector.detectCodePage(is, Integer.MAX_VALUE);
            }
            catch (IllegalArgumentException e) {
                charset = Charset.forName(ResourceHelper.defaultFileEncoding());
                Logger.warn((Object)("get file encoding error:" + e.getMessage() + ", use default encoding:" + ResourceHelper.defaultFileEncoding()), (Throwable[])new Throwable[0]);
            }
            String fileCharacterEnding = charset.name();
            return fileCharacterEnding;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return ResourceHelper.defaultFileEncoding();
        }
    }

    public static InputStream getResourceAsStream(ClassLoader klassLoader, String file) throws FileNotFoundException {
        String _file = file;
        if (file == null) {
            throw new RuntimeException("execute file name can't be null!");
        }
        if (file.startsWith("file:")) {
            _file = file.replaceFirst("file:", "");
            return new FileInputStream(new File(_file));
        }
        if (file.startsWith("classpath:")) {
            _file = file.replaceFirst("classpath:", "");
        }
        return klassLoader.getResourceAsStream(_file);
    }

    public static URL getResourceUrl(String filename) {
        if (filename == null) {
            throw new RuntimeException("execute file name can't be null!");
        }
        if (filename.startsWith("file:")) {
            String _filename = filename.replaceFirst("file:", "");
            File file = new File(_filename);
            URL url = null;
            try {
                url = file.toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return url;
        }
        String resource = filename;
        if (filename.startsWith("classpath:")) {
            resource = filename.replaceFirst("classpath:", "");
        }
        URL url = ResourceHelper.class.getClassLoader().getResource(resource);
        return url;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFromClasspath(String file) {
        try (InputStream is = ResourceHelper.class.getClassLoader().getResourceAsStream(file);){
            String string = ResourceHelper.readFromStream(is);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream getResourceAsStream(Class clazz, String fileName) throws FileNotFoundException {
        String packPath = ClazzHelper.getPathFromPath(clazz);
        String url = StringHelper.isBlank(packPath) ? fileName : packPath + "/" + fileName;
        InputStream is = ResourceHelper.class.getClassLoader().getResourceAsStream(url);
        if (is == null && !StringHelper.isBlank(packPath)) {
            is = clazz.getClassLoader().getResourceAsStream(fileName);
        }
        if (is == null) {
            if (StringHelper.isBlank(packPath)) {
                throw new FileNotFoundException(String.format("can't find class path resource in in classpath: [%s].", fileName));
            }
            throw new FileNotFoundException(String.format("can't find class path resource in in classpaths: [%s] and [%s]", url, fileName));
        }
        return is;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFromFile(ClassLoader klassLoader, String file) {
        try (InputStream stream = ResourceHelper.getResourceAsStream(klassLoader, file);){
            String string = ResourceHelper.readFromStream(stream);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFromFile(String file) {
        try (InputStream stream = ResourceHelper.getResourceAsStream(ResourceHelper.class.getClassLoader(), file);){
            String string = ResourceHelper.readFromStream(stream);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] readLinesFromFile(File file) {
        try (FileInputStream stream = new FileInputStream(file);){
            String[] stringArray = ResourceHelper.readLinesFromStream(stream);
            return stringArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readFromFile(File file) throws FileNotFoundException {
        if (file == null) {
            throw new RuntimeException("the file can't be null.");
        }
        if (!file.exists()) {
            throw new RuntimeException(String.format("the file[%s] isn't exists.", file.getName()));
        }
        String encoding = ResourceHelper.getFileEncodingCharset(file);
        String content = ResourceHelper.readFromStream(new FileInputStream(file), encoding);
        return content;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFromFile(Class clazz, String fileName) {
        if (StringHelper.isBlank(fileName)) {
            throw new RuntimeException("file name can't be null.");
        }
        if (fileName.startsWith("file:")) return ResourceHelper.readFromFile(clazz.getClassLoader(), fileName);
        if (fileName.startsWith("classpath:")) {
            return ResourceHelper.readFromFile(clazz.getClassLoader(), fileName);
        }
        try (InputStream is = ResourceHelper.getResourceAsStream(clazz, fileName);){
            String content;
            String string = content = ResourceHelper.readFromStream(is);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] readLinesFromFile(ClassLoader klassLoader, String filePath) {
        try (InputStream stream = ResourceHelper.getResourceAsStream(klassLoader, filePath);){
            String[] lines;
            String[] stringArray = lines = ResourceHelper.readLinesFromStream(stream);
            return stringArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] readLinesFromFile(ClassLoader klassLoader, String filePath, String encoding) {
        try (InputStream stream = ResourceHelper.getResourceAsStream(klassLoader, filePath);){
            String[] lines;
            String[] stringArray = lines = ResourceHelper.readLinesFromStream(stream, encoding);
            return stringArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isResourceExists(Class claz, String file) {
        String pack = ClazzHelper.getPathFromPath(claz);
        String path = StringHelper.isBlank(pack) ? file : pack + "/" + file;
        try {
            URL url = ClassLoader.getSystemResource(path);
            return url != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static String getSuffixPath(File basePath, String filePath) {
        String prefixPath = basePath.getAbsolutePath().replaceAll("[\\/\\\\]+", "/");
        String fullPath = filePath.replaceAll("[\\/\\\\]+", "/");
        String suffixPath = filePath;
        if (fullPath.startsWith(prefixPath)) {
            suffixPath = fullPath.replace(prefixPath, "");
        }
        if (suffixPath.startsWith("/")) {
            suffixPath = suffixPath.substring(1);
        }
        return suffixPath;
    }

    public static boolean deleteFileOrDir(String path) {
        try {
            return ResourceHelper.deleteFileOrDir(new File(path));
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean deleteFileOrDir(File path) {
        File[] files;
        if (!path.exists()) {
            return true;
        }
        if (path.isFile()) {
            path.delete();
            return true;
        }
        for (File file : files = path.listFiles()) {
            if (file.isDirectory()) {
                ResourceHelper.deleteFileOrDir(file);
                continue;
            }
            file.delete();
        }
        return path.delete();
    }

    public static void mkFileParentDir(File file) {
        File path = file.getParentFile();
        if (!path.exists()) {
            path.mkdirs();
        }
    }
}

