/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.commons;

import org.test4j.functions.SExecutor;

public class TextBuilder {
    public static final String NEWLINE = "\n";
    private final StringBuilder buff = new StringBuilder();
    private boolean endNewLine = false;

    public static TextBuilder build() {
        return new TextBuilder();
    }

    public TextBuilder append(TextBuilder appender) {
        this.buff.append(appender.toString());
        return this;
    }

    public TextBuilder append(String format, Object ... args) {
        if (args == null || args.length == 0) {
            this.buff.append(format);
        } else {
            this.buff.append(String.format(format, args));
        }
        this.endNewLine = false;
        return this;
    }

    public TextBuilder append(SExecutor executor) {
        try {
            executor.doIt();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    private static String replace(String input) {
        return input.replace('\'', '\"');
    }

    public TextBuilder quotas(String format, Object ... args) {
        if (args == null || args.length == 0) {
            this.buff.append(TextBuilder.replace(format));
        } else {
            this.buff.append(String.format(TextBuilder.replace(format), args));
        }
        this.endNewLine = false;
        return this;
    }

    public TextBuilder newLine() {
        if (!this.endNewLine) {
            this.buff.append(NEWLINE);
        }
        this.endNewLine = true;
        return this;
    }

    public TextBuilder newLine(int count) {
        for (int loop = 0; loop < count; ++loop) {
            this.buff.append(NEWLINE);
            this.endNewLine = true;
        }
        return this;
    }

    public String toString() {
        return this.buff.toString();
    }
}

