/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.cpdetector;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import org.test4j.tools.cpdetector.ICodepageDetector;

public abstract class AbstractCodepageDetector
implements ICodepageDetector {
    @Override
    public Charset detectCodePage(URL url) throws IOException {
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        Charset result = this.detectCodePage(in, Integer.MAX_VALUE);
        in.close();
        return result;
    }

    @Override
    public final Reader open(URL url) throws IOException {
        InputStreamReader ret = null;
        Charset cs = this.detectCodePage(url);
        if (cs != null) {
            ret = new InputStreamReader((InputStream)new BufferedInputStream(url.openStream()), cs);
        }
        return ret;
    }

    @Override
    public int compareTo(ICodepageDetector o) {
        String other = o.getClass().getName();
        String mine = super.getClass().getName();
        return mine.compareTo(other);
    }
}

