/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.cpdetector;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.test4j.tools.cpdetector.AbstractCodePageDetector1;
import org.test4j.tools.cpdetector.UnknownCharset;
import org.test4j.tools.cpdetector.UnsupportedCharset;
import org.test4j.tools.cpdetector.mozilla.NsDetector;
import org.test4j.tools.cpdetector.mozilla.NsICharsetDetectionObserver;

public class JChardetFacade
extends AbstractCodePageDetector1
implements NsICharsetDetectionObserver {
    private static JChardetFacade instance = null;
    private static NsDetector det;
    private byte[] buf = new byte[4096];
    private Charset codpage = null;
    private int amountOfVerifiers = 0;

    private JChardetFacade() {
        det = new NsDetector(3);
        det.init(this);
        this.amountOfVerifiers = det.getProbableCharsets().length;
    }

    public static JChardetFacade getInstance() {
        if (instance == null) {
            instance = new JChardetFacade();
        }
        return instance;
    }

    @Override
    public synchronized Charset detectCodePage(InputStream in, int length) throws IOException {
        int len;
        this.reset();
        int read = 0;
        boolean done = false;
        Charset ret = null;
        do {
            if ((len = in.read(this.buf, 0, Math.min(this.buf.length, length - read))) > 0) {
                read += len;
            }
            if (done) continue;
            done = det.doIt(this.buf, len, false);
        } while (len > 0 && !done);
        det.dataEnd();
        ret = this.codpage == null ? this.guess() : this.codpage;
        return ret;
    }

    private Charset guess() {
        Charset ret = null;
        String[] possibilities = det.getProbableCharsets();
        if (possibilities.length == this.amountOfVerifiers) {
            ret = Charset.forName("US-ASCII");
        } else {
            String check = possibilities[0];
            if (check.equalsIgnoreCase("nomatch")) {
                ret = UnknownCharset.getInstance();
            } else {
                for (int i = 0; ret == null && i < possibilities.length; ++i) {
                    try {
                        ret = Charset.forName(possibilities[i]);
                        continue;
                    }
                    catch (UnsupportedCharsetException uce) {
                        ret = UnsupportedCharset.forName(possibilities[i]);
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public void notify(String charset) {
        this.codpage = Charset.forName(charset);
    }

    public void reset() {
        det.reset();
        this.codpage = null;
    }
}

