/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.cpdetector.mozilla;

import org.test4j.tools.cpdetector.mozilla.NsBIG5Verifier;
import org.test4j.tools.cpdetector.mozilla.NsGB2312Verifier;
import org.test4j.tools.cpdetector.mozilla.NsHZVerifier;
import org.test4j.tools.cpdetector.mozilla.NsISO2022CNVerifier;
import org.test4j.tools.cpdetector.mozilla.NsUTF8Verifier;
import org.test4j.tools.cpdetector.mozilla.NsVerifier;

public abstract class NsPSMDetector {
    public static final int ALL = 0;
    public static final int JAPANESE = 1;
    public static final int CHINESE = 2;
    public static final int SIMPLIFIED_CHINESE = 3;
    public static final int TRADITIONAL_CHINESE = 4;
    public static final int KOREAN = 5;
    public static final int NO_OF_LANGUAGES = 6;
    public static final int MAX_VERIFIERS = 16;
    NsVerifier[] mVerifier;
    byte[] mState = new byte[16];
    int[] mItemIdx = new int[16];
    int mItems;
    int mClassItems;
    boolean mDone;
    boolean mRunSampler;
    boolean mClassRunSampler;

    public NsPSMDetector() {
        this.initVerifiers(0);
        this.reset();
    }

    public NsPSMDetector(int langFlag) {
        this.initVerifiers(langFlag);
        this.reset();
    }

    public void reset() {
        this.mRunSampler = this.mClassRunSampler;
        this.mDone = false;
        this.mItems = this.mClassItems;
        for (int i = 0; i < this.mItems; ++i) {
            this.mState[i] = 0;
            this.mItemIdx[i] = i;
        }
    }

    protected void initVerifiers(int currVerSet) {
        boolean idx = false;
        int currVerifierSet = currVerSet >= 0 && currVerSet < 6 ? currVerSet : 0;
        this.mVerifier = null;
        this.mVerifier = currVerifierSet == 4 ? new NsVerifier[]{new NsUTF8Verifier(), new NsBIG5Verifier(), new NsISO2022CNVerifier(), new NsGB2312Verifier()} : (currVerifierSet == 3 ? new NsVerifier[]{new NsUTF8Verifier(), new NsGB2312Verifier(), new NsISO2022CNVerifier(), new NsHZVerifier()} : new NsVerifier[]{new NsUTF8Verifier(), new NsGB2312Verifier(), new NsBIG5Verifier(), new NsISO2022CNVerifier(), new NsHZVerifier()});
        this.mClassItems = this.mVerifier.length;
    }

    public abstract void report(String var1);

    public boolean HandleData(byte[] aBuf, int len) {
        for (int i = 0; i < len; ++i) {
            byte b = aBuf[i];
            int j = 0;
            while (j < this.mItems) {
                byte st = NsVerifier.getNextState(this.mVerifier[this.mItemIdx[j]], b, this.mState[j]);
                if (st == 2) {
                    this.report(this.mVerifier[this.mItemIdx[j]].charset());
                    this.mDone = true;
                    return this.mDone;
                }
                if (st == 1) {
                    --this.mItems;
                    if (j >= this.mItems) continue;
                    this.mItemIdx[j] = this.mItemIdx[this.mItems];
                    this.mState[j] = this.mState[this.mItems];
                    continue;
                }
                this.mState[j++] = st;
            }
            int nonUCS2Num = 0;
            int nonUCS2Idx = 0;
            for (j = 0; j < this.mItems; ++j) {
                if (this.mVerifier[this.mItemIdx[j]].isUCS2() || this.mVerifier[this.mItemIdx[j]].isUCS2()) continue;
                ++nonUCS2Num;
                nonUCS2Idx = j;
            }
            if (true != nonUCS2Num) continue;
            this.report(this.mVerifier[this.mItemIdx[nonUCS2Idx]].charset());
            this.mDone = true;
            return this.mDone;
        }
        return this.mDone;
    }

    public void dataEnd() {
        if (this.mDone) {
            return;
        }
        if (this.mItems == 2) {
            if (this.mVerifier[this.mItemIdx[0]].charset().equals("GB18030")) {
                this.report(this.mVerifier[this.mItemIdx[1]].charset());
                this.mDone = true;
            } else if (this.mVerifier[this.mItemIdx[1]].charset().equals("GB18030")) {
                this.report(this.mVerifier[this.mItemIdx[0]].charset());
                this.mDone = true;
            }
        }
    }

    public String[] getProbableCharsets() {
        String[] ret = new String[this.mItems];
        for (int i = 0; i < this.mItems; ++i) {
            ret[i] = this.mVerifier[this.mItemIdx[i]].charset();
        }
        return ret;
    }
}

