/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.datagen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.test4j.tools.commons.ArrayHelper;
import org.test4j.tools.datagen.DataGenerator;
import org.test4j.tools.datagen.IColData;
import org.test4j.tools.datagen.IDataMap;
import org.test4j.tools.json.JSON;

class AbstractDataMap
extends LinkedHashMap<String, IColData>
implements IDataMap<AbstractDataMap> {
    private static final long serialVersionUID = 1L;
    private final boolean isRowMap;
    private final int rowSize;

    AbstractDataMap() {
        this.rowSize = 1;
        this.isRowMap = false;
    }

    AbstractDataMap(int rowSize) {
        this.rowSize = rowSize;
        this.isRowMap = true;
    }

    AbstractDataMap(Map<String, Object> map) {
        this();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.kv(entry.getKey(), entry.getValue(), new Object[0]);
        }
    }

    @Override
    public Map<String, Object> row(int row) {
        if (row < 0) {
            throw new RuntimeException("the index can't less than zero.");
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Map.Entry entry : this.entrySet()) {
            data.put((String)entry.getKey(), ((IColData)entry.getValue()).row(row));
        }
        return data;
    }

    @Override
    public AbstractDataMap init(Map map) {
        if (map != null) {
            map.forEach((k, v) -> this.kv(String.valueOf(k), v, new Object[0]));
        }
        return this;
    }

    @Override
    public IColData get(String key) {
        return (IColData)super.get(key);
    }

    @Override
    public Set<String> keySet() {
        return super.keySet();
    }

    @Override
    public List cols(String key) {
        ArrayList<Object> list = new ArrayList<Object>(this.rowSize);
        for (int row = 0; row < this.rowSize; ++row) {
            list.add(this.get(key).row(row));
        }
        return list;
    }

    @Override
    public AbstractDataMap arr(String key, Object ... arr) {
        if (this.isRowMap) {
            if (arr == null || arr.length == 0) {
                this.putMulRowValue(key, null, new Object[0]);
            } else {
                this.putMulRowValue(key, arr[0], Arrays.copyOfRange(arr, 1, arr.length));
            }
        } else {
            this.putOneRowValue(key, arr, new Object[0]);
        }
        return this;
    }

    @Override
    public AbstractDataMap kv(String key, Object value, Object ... values) {
        if (this.isRowMap) {
            this.putMulRowValue(key, value, values);
        } else {
            this.putOneRowValue(key, value, values);
        }
        return this;
    }

    private void putMulRowValue(String key, Object value, Object[] values) {
        IColData.MulRowValue row = new IColData.MulRowValue();
        if (value instanceof DataGenerator) {
            ((DataGenerator)value).setDataMap(this);
        }
        row.add(value);
        if (values == null) {
            row.add(null);
            this.put(key, row);
            return;
        }
        boolean isFirstArray = ArrayHelper.isArray(value);
        boolean is2dArray = false;
        for (Object item : values) {
            if (!ArrayHelper.isArray(item)) continue;
            is2dArray = true;
        }
        if (isFirstArray && !is2dArray) {
            row.add(values);
        } else {
            Stream.of(values).forEach(row::add);
        }
        this.put(key, row);
    }

    private void putOneRowValue(String key, Object value, Object[] values) {
        if (values != null && values.length != 0) {
            throw new RuntimeException("this DataMap isn't a RowMap, please use parametrical constructor\uff1anew DataMap(size)");
        }
        this.put(key, new IColData.OneRowValue(value));
    }

    @Override
    public void put(String key, Object value) {
        if (value instanceof IColData) {
            if (!this.isRowMap || value instanceof IColData.OneRowValue) {
                this.kv(key, ((IColData)value).row(0), new Object[0]);
            } else {
                this.put(key, (IColData)value);
            }
        } else {
            throw new RuntimeException("please use .kv(String, Object, Object ...)");
        }
    }

    @Override
    public List<Map<String, ?>> rows() {
        ArrayList list = new ArrayList(this.rowSize);
        for (int row = 0; row < this.rowSize; ++row) {
            list.add(this.row(row));
        }
        return list;
    }

    @Override
    public <R> List<R> rows(Class<R> klass) {
        return JSON.toList(JSON.toJSON(this.rows(), false), klass);
    }

    @Override
    public int getColSize() {
        return this.size();
    }

    @Override
    public boolean containsKey(String key) {
        return super.containsKey(key);
    }

    @Override
    public String toString() {
        if (this.isRowMap) {
            return JSON.toJSON(this.rows(), false);
        }
        return JSON.toJSON(this.row(1), false);
    }

    @Override
    public boolean isRowMap() {
        return this.isRowMap;
    }

    @Override
    public int getRowSize() {
        return this.rowSize;
    }
}

