/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.datagen;

import java.util.ArrayList;
import java.util.List;
import org.test4j.tools.datagen.DataGenerator;
import org.test4j.tools.json.JSON;

public interface IColData {
    public Object row(int var1);

    public List rows(int var1);

    public List rows();

    public <T extends IColData> T add(Object var1);

    public static class MulRowValue
    implements IColData {
        private final List list = new ArrayList();
        private DataGenerator generator = null;

        public MulRowValue add(Object value) {
            if (value instanceof DataGenerator) {
                this.generator = (DataGenerator)value;
            } else {
                this.list.add(value);
            }
            return this;
        }

        @Override
        public Object row(int row) {
            if (row < 0) {
                throw new RuntimeException("index can't less than zero.");
            }
            int size = this.list.size();
            if (row < size) {
                return this.list.get(row);
            }
            if (this.generator == null) {
                return this.list.isEmpty() ? null : this.list.get(size - 1);
            }
            return this.generator.generate(row);
        }

        @Override
        public List rows(int size) {
            ArrayList<Object> list = new ArrayList<Object>(size);
            for (int index = 0; index < size; ++index) {
                list.add(this.row(index));
            }
            return list;
        }

        @Override
        public List rows() {
            return this.rows(this.list.isEmpty() ? 1 : this.list.size());
        }

        public String toString() {
            return JSON.toJSON(this.rows(), false);
        }

        public List getList() {
            return this.list;
        }

        public DataGenerator getGenerator() {
            return this.generator;
        }

        public void setGenerator(DataGenerator generator) {
            this.generator = generator;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MulRowValue)) {
                return false;
            }
            MulRowValue other = (MulRowValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List this$list = this.getList();
            List other$list = other.getList();
            if (this$list == null ? other$list != null : !((Object)this$list).equals(other$list)) {
                return false;
            }
            DataGenerator this$generator = this.getGenerator();
            DataGenerator other$generator = other.getGenerator();
            return !(this$generator == null ? other$generator != null : !this$generator.equals(other$generator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MulRowValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List $list = this.getList();
            result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
            DataGenerator $generator = this.getGenerator();
            result = result * 59 + ($generator == null ? 43 : $generator.hashCode());
            return result;
        }
    }

    public static class OneRowValue
    implements IColData {
        private Object value;

        public OneRowValue(Object value) {
            this.value = value;
        }

        public OneRowValue add(Object value) {
            this.value = value;
            return this;
        }

        @Override
        public Object row(int row) {
            return this.value;
        }

        @Override
        public List rows(int size) {
            ArrayList<Object> list = new ArrayList<Object>(size);
            for (int index = 0; index < size; ++index) {
                list.add(this.value);
            }
            return list;
        }

        @Override
        public List rows() {
            return this.rows(1);
        }

        public String toString() {
            return JSON.toJSON(this.value, false);
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OneRowValue)) {
                return false;
            }
            OneRowValue other = (OneRowValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OneRowValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }
}

