/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.datagen;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.test4j.tools.datagen.DataGenerator;

public class IncreaseDataGenerator
extends DataGenerator {
    private Number from;
    private Number step;

    public IncreaseDataGenerator(Number from, Number step) {
        this.from = from;
        this.step = step;
    }

    @Override
    public Object generate(int index) {
        if (this.from instanceof Integer) {
            Integer value = this.from.intValue() + this.step.intValue() * index;
            return value;
        }
        if (this.from instanceof Long) {
            Long value = this.from.longValue() + this.step.longValue() * (long)index;
            return value;
        }
        if (this.from instanceof Short) {
            Integer value = this.from.shortValue() + this.step.shortValue() * index;
            return Short.valueOf(String.valueOf(value));
        }
        if (this.from instanceof BigInteger) {
            Long value = this.from.longValue() + this.step.longValue() * (long)index;
            return BigInteger.valueOf(value);
        }
        if (this.from instanceof Double) {
            Double value = this.from.doubleValue() + this.step.doubleValue() * (double)index;
            return value;
        }
        if (this.from instanceof Float) {
            Float value = Float.valueOf(this.from.floatValue() + this.step.floatValue() * (float)index);
            return value;
        }
        if (this.from instanceof BigDecimal) {
            Double value = this.from.doubleValue() + this.step.doubleValue() * (double)index;
            return BigDecimal.valueOf(value);
        }
        throw new RuntimeException("unsupport this type number increase, only support type[int, long, short, double, float, BigInteger, BigDecimal].");
    }
}

