/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.datagen;

import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.test4j.tools.datagen.DataGenerator;
import org.test4j.tools.datagen.IDataMap;

public class KeyValue<M extends IDataMap> {
    private final M map;
    private final String column;
    private final String property;
    private final Supplier<Boolean> isTable;
    private static Random random = new Random(System.currentTimeMillis());

    public KeyValue(M map, String column) {
        this.map = map;
        this.column = column;
        this.property = null;
        this.isTable = () -> true;
    }

    public KeyValue(M map, String column, String property, Supplier<Boolean> isTable) {
        this.map = map;
        this.column = column;
        this.property = property;
        this.isTable = isTable;
    }

    public M values(Object value, Object ... values) {
        this.map.kv(this.key(), value, values);
        return this.map;
    }

    public M values(final Function<Integer, Integer> changeIndex, final Object ... values) {
        if (changeIndex == null) {
            this.map.kv(this.key(), null, values);
            return this.map;
        }
        if (values == null || values.length == 0) {
            throw new RuntimeException("the values should be specified.");
        }
        DataGenerator generator = new DataGenerator(){

            @Override
            public Object generate(int index) {
                Integer _index = (Integer)changeIndex.apply(index);
                if (_index == null || _index < 0) {
                    _index = 0;
                }
                if (_index >= values.length) {
                    _index = values.length - 1;
                }
                return values[_index];
            }
        };
        this.map.kv(this.key(), generator, new Object[0]);
        return this.map;
    }

    public M increase(Number start, Number step) {
        this.map.kv(this.key(), DataGenerator.increase(start, step), new Object[0]);
        return this.map;
    }

    public M autoIncrease() {
        this.map.kv(this.key(), DataGenerator.increase(1, 1), new Object[0]);
        return this.map;
    }

    public M formatIncrease(String format, Number start, Number step) {
        this.map.kv(this.key(), DataGenerator.increase(format, start, step), new Object[0]);
        return this.map;
    }

    public M formatAutoIncrease(String format) {
        this.map.kv(this.key(), DataGenerator.increase(format, (Number)1, 1), new Object[0]);
        return this.map;
    }

    public M functionIncrease(Function<Integer, Object> function, Number start, Number step) {
        this.map.kv(this.key(), DataGenerator.increase(start, step, function), new Object[0]);
        return this.map;
    }

    public M functionAutoIncrease(Function<Integer, Object> function) {
        this.map.kv(this.key(), DataGenerator.increase(1, (Number)1, function), new Object[0]);
        return this.map;
    }

    public <O> M functionObjs(Function<O, Object> function, O value, O ... values) {
        Object[] items = Stream.of(values).map(function::apply).collect(Collectors.toList()).toArray(new Object[0]);
        this.map.kv(this.key(), function.apply(value), items);
        return this.map;
    }

    public M loop(Object ... loops) {
        this.map.kv(this.key(), DataGenerator.repeat(loops), new Object[0]);
        return this.map;
    }

    public <O> M generateBy(final BiFunction<Integer, O[], Object> generator, final O ... values) {
        if (values == null || values.length == 0) {
            throw new RuntimeException("the values should be specified.");
        }
        DataGenerator _generator = new DataGenerator(){

            @Override
            public Object generate(int index) {
                return generator.apply(index, values);
            }
        };
        this.map.kv(this.key(), _generator, new Object[0]);
        return this.map;
    }

    public M generate(final Function<Integer, Object> generator) {
        DataGenerator _generator = new DataGenerator(){

            @Override
            public Object generate(int index) {
                return generator.apply(index);
            }
        };
        this.map.kv(this.key(), _generator, new Object[0]);
        return this.map;
    }

    public M random() {
        this.map.kv(this.key(), DataGenerator.random(this.key().getClass()), new Object[0]);
        return this.map;
    }

    public M random(final Object ... randoms) {
        if (randoms == null || randoms.length == 0) {
            throw new RuntimeException("the randoms should be specified.");
        }
        DataGenerator generator = new DataGenerator(){

            @Override
            public Object generate(int index) {
                int _index = Math.abs(random.nextInt()) % randoms.length;
                return randoms[_index];
            }
        };
        this.map.kv(this.key(), generator, new Object[0]);
        return this.map;
    }

    private String key() {
        return this.isTable.get() != false ? this.column : this.property;
    }
}

