/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.reflector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.test4j.exception.NoSuchFieldRuntimeException;
import org.test4j.tools.commons.ArrayHelper;
import org.test4j.tools.commons.ClazzHelper;
import org.test4j.tools.commons.ListHelper;
import org.test4j.tools.commons.StringHelper;
import org.test4j.tools.reflector.FieldAccessor;
import org.test4j.tools.reflector.MethodAccessor;

public class PropertyAccessor {
    public static Object getPropertyByOgnl(Object target, String ognl) {
        Object o = PropertyAccessor.getPropertyByOgnl(target, ognl, true);
        return o;
    }

    public static Object getPropertyByOgnl(Object object, String ognl, boolean throwNoProperty) {
        String[] expressions = ognl.split("\\.");
        try {
            Object target = object;
            String key = "";
            for (String prop : expressions) {
                if (target == null && !throwNoProperty) {
                    return null;
                }
                if (target instanceof Map) {
                    Map map = (Map)target;
                    String string = key = key.equals("") ? prop : key + "." + prop;
                    if (!map.containsKey(key)) continue;
                    target = map.get(key);
                    key = "";
                    continue;
                }
                target = PropertyAccessor.getProperty(target, prop);
            }
            if (!key.equals("")) {
                throw new NoSuchFieldRuntimeException();
            }
            return target;
        }
        catch (NoSuchFieldRuntimeException e) {
            if (throwNoProperty) {
                String clazname = object == null ? "null" : object.getClass().getName();
                throw new NoSuchFieldRuntimeException("can't find property[" + ognl + "] in object[" + clazname + "]", e);
            }
            return object;
        }
    }

    public static Object getProperty(Object o, String prop) {
        if (o == null) {
            throw new RuntimeException("can't get the property value from a null object.");
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            if (map.containsKey(prop)) {
                return map.get(prop);
            }
            throw new NoSuchFieldRuntimeException("no key[" + prop + "] value in map.");
        }
        Object target = ClazzHelper.getProxiedObject(o);
        try {
            String method = StringHelper.camel("get", prop);
            return MethodAccessor.invoke(target, method, new Object[0]);
        }
        catch (Throwable e) {
            try {
                String method = StringHelper.camel("is", prop);
                Object result = MethodAccessor.invoke(target, method, new Object[0]);
                if (result instanceof Boolean) {
                    return result;
                }
                throw new RuntimeException();
            }
            catch (Throwable e1) {
                Object o2 = FieldAccessor.getValue(target, prop);
                return o2;
            }
        }
    }

    public static Object[] getPropertyValue(Object object, String[] ognls, boolean throwException) {
        ArrayList<Object> os = new ArrayList<Object>();
        for (String ognl : ognls) {
            Object value = PropertyAccessor.getPropertyByOgnl(object, ognl, throwException);
            os.add(value);
        }
        return os.toArray(new Object[0]);
    }

    public static List<?> getArrayItemProperty(Object arr, String property) {
        List coll = ListHelper.toList(arr);
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object o : coll) {
            Object value = PropertyAccessor.getPropertyByOgnl(o, property, false);
            values.add(value);
        }
        return values;
    }

    public static Collection getArrayOrItemProperty(Object item, String property) {
        List values = null;
        if (ArrayHelper.isCollOrArray(item)) {
            values = PropertyAccessor.getArrayItemProperty(item, property);
        } else {
            Object o = PropertyAccessor.getProperty(item, property);
            values = ListHelper.toList(o);
        }
        return values;
    }

    public static Object[][] getArrayItemProperties(Object arr, String[] properties) {
        List coll = ListHelper.toList(arr);
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (Object o : coll) {
            Object[] props = PropertyAccessor.getPropertyValue(o, properties, false);
            values.add(props);
        }
        return (Object[][])values.toArray((T[])new Object[0][0]);
    }

    public static List<List> getPropertiesOfList(List list, String[] properties, boolean throwNoProperty) {
        ArrayList<List> result = new ArrayList<List>();
        for (Object target : list) {
            ArrayList<Object> items = new ArrayList<Object>();
            if (ArrayHelper.isCollOrArray(target) && !throwNoProperty) {
                List value = ListHelper.toList(target);
                result.add(value);
                continue;
            }
            for (String ognl : properties) {
                Object value = PropertyAccessor.getPropertyByOgnl(target, ognl, throwNoProperty);
                items.add(value);
            }
            result.add(items);
        }
        return result;
    }

    public static List<List> getPropertySetsOfList(List list, String[] properties, boolean throwNoProperty) {
        ArrayList<List> result = new ArrayList<List>();
        for (String ognl : properties) {
            ArrayList<Object> items = new ArrayList<Object>();
            for (Object target : list) {
                if (ArrayHelper.isCollOrArray(target)) {
                    List _target = ListHelper.toList(target);
                    List values = PropertyAccessor.getPropertyOfList(_target, ognl, throwNoProperty);
                    items.add(values);
                    continue;
                }
                Object value = PropertyAccessor.getPropertyByOgnl(target, ognl, throwNoProperty);
                items.add(value);
            }
            result.add(items);
        }
        return result;
    }

    public static List getPropertyOfList(List list, String ognl, boolean throwNoProperty) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object target : list) {
            Object value = PropertyAccessor.getPropertyByOgnl(target, ognl, throwNoProperty);
            result.add(value);
        }
        return result;
    }

    public static List getPropertiesOfPoJo(Object target, String[] properties, boolean throwNoProperty) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String ognl : properties) {
            Object value = PropertyAccessor.getPropertyByOgnl(target, ognl, throwNoProperty);
            result.add(value);
        }
        return result;
    }
}

