/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.diff;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.test4j.hamcrest.diff.BaseDiff;
import org.test4j.hamcrest.diff.DiffFactory;
import org.test4j.hamcrest.diff.DiffMap;
import org.test4j.hamcrest.diff.ListMatchItem;
import org.test4j.hamcrest.matcher.modes.EqMode;
import org.test4j.tools.commons.ArrayHelper;
import org.test4j.tools.commons.ListHelper;
import org.test4j.tools.datagen.IDataMap;

public class DiffByList
extends BaseDiff {
    public DiffByList(BaseDiff diff) {
        super(diff);
    }

    public DiffByList(EqMode ... modes) {
        super(modes);
    }

    public DiffMap compare(Object parentKey, Object actual, Object expect) {
        List expectList;
        if (this.validateNull(parentKey, actual, expect)) {
            return this.diffMap;
        }
        if (!ArrayHelper.isCollOrArray(actual)) {
            this.diffMap.add(parentKey, "actual should be a List", "expect should be a Map List");
            return this.diffMap;
        }
        List actualList = ListHelper.toList(actual, false);
        if (expect instanceof IDataMap) {
            expectList = ((IDataMap)expect).rows();
        } else if (ArrayHelper.isCollOrArray(expect)) {
            expectList = ListHelper.toList(expect, false);
        } else {
            this.diffMap.add(parentKey, "actual is a List", "expect should be a Map List");
            return this.diffMap;
        }
        int size = expectList.size();
        if (actualList.size() != size) {
            this.diffMap.add(parentKey, "the size is " + actualList.size(), "the size is " + size);
            return this.diffMap;
        }
        if (this.ignoreOrder) {
            this.compareIgnoreOrder(parentKey, actualList, expectList);
        } else {
            this.compareWithOrder(parentKey, actualList, expectList);
        }
        return this.diffMap;
    }

    private void compareWithOrder(Object parentKey, List actualList, List expectList) {
        for (int index = 0; index < expectList.size(); ++index) {
            String key = parentKey + "[" + index + "]";
            new DiffFactory(this).compare((Object)key, actualList.get(index), expectList.get(index));
        }
    }

    private void compareIgnoreOrder(Object parentKey, List actualList, List<Map> expectList) {
        HashMap<Integer, ListMatchItem> all = new HashMap<Integer, ListMatchItem>();
        int size = expectList.size();
        HashSet<Integer> matchedExpected = new HashSet<Integer>(size);
        for (int index = 0; index < size; ++index) {
            Object actual = actualList.get(index);
            ListMatchItem child = new ListMatchItem(index, matchedExpected);
            this.compareWithExpect(parentKey, actual, expectList, child);
            all.put(index, child);
        }
        HashSet<Integer> existedDiffIndex = new HashSet<Integer>(size);
        for (Map.Entry entry : all.entrySet()) {
            ListMatchItem item = (ListMatchItem)entry.getValue();
            if (item.getExpectIndex() != null) continue;
            item.remove(matchedExpected);
            DiffMap minDiff = this.findMinDiff(existedDiffIndex, item);
            this.diffMap.add(minDiff);
        }
    }

    private DiffMap findMinDiff(Set<Integer> existedDiffIndex, ListMatchItem item) {
        Map.Entry<Integer, DiffMap> minDiff = null;
        Map.Entry<Integer, DiffMap> _default = null;
        for (Map.Entry<Integer, DiffMap> child : item.getDiffItem().entrySet()) {
            if (_default == null) {
                _default = child;
            }
            if (existedDiffIndex.contains(child.getKey()) || minDiff != null && minDiff.getValue().diffCount() <= child.getValue().diffCount()) continue;
            minDiff = child;
        }
        if (minDiff == null) {
            minDiff = _default;
        }
        existedDiffIndex.add((Integer)minDiff.getKey());
        return minDiff.getValue();
    }

    private ListMatchItem compareWithExpect(Object parentKey, Object actual, List<Map> expectList, ListMatchItem child) {
        HashMap<Integer, DiffMap> matched = new HashMap<Integer, DiffMap>(expectList.size());
        for (int loop = 0; loop < expectList.size(); ++loop) {
            if (child.hasMatched(loop)) continue;
            String key = parentKey + "[" + (loop + 1) + "]~[" + (child.getActualIndex() + 1) + "]";
            DiffMap diff = new DiffFactory(this, new DiffMap()).compare((Object)key, actual, expectList.get(loop));
            if (diff.hasDiff()) {
                child.addMatched(loop, diff);
                continue;
            }
            matched.put(loop, diff);
        }
        DiffMap maxMatched = null;
        Integer maxIndex = null;
        for (Map.Entry entry : matched.entrySet()) {
            if (maxMatched != null && maxMatched.getIgnoreCount() <= ((DiffMap)entry.getValue()).getIgnoreCount()) continue;
            maxMatched = (DiffMap)entry.getValue();
            maxIndex = (Integer)entry.getKey();
        }
        if (maxMatched != null) {
            child.addMatched(maxIndex, maxMatched);
        }
        return child;
    }
}

