/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.diff;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.test4j.hamcrest.diff.BaseDiff;
import org.test4j.hamcrest.diff.DiffFactory;
import org.test4j.hamcrest.diff.DiffMap;
import org.test4j.hamcrest.matcher.modes.EqMode;
import org.test4j.tools.reflector.MethodAccessor;
import org.test4j.tools.reflector.Reflector;

public class DiffByReflect
extends BaseDiff {
    static final String JAVA_INTERNAL_TYPE = "java.";

    public DiffByReflect(BaseDiff diff) {
        super(diff);
    }

    public DiffByReflect(EqMode ... modes) {
        super(modes);
    }

    public DiffMap compare(Object parentKey, Object actual, Object expect) {
        if (this.validateNull(parentKey, actual, expect)) {
            return this.diffMap;
        }
        if (this.isDate(actual)) {
            if (!this.ignoreDateType) {
                this.compareDate(parentKey, actual, expect);
            }
            return this.diffMap;
        }
        if (actual instanceof Number) {
            this.compareNumber(parentKey, (Number)actual, expect);
        } else if (actual.getClass().getName().startsWith(JAVA_INTERNAL_TYPE)) {
            Object _actual;
            Object _expect = super.asObject(expect, this.asString);
            if (!_expect.equals(_actual = super.asObject(actual, this.asString))) {
                this.diffMap.add(parentKey, actual, expect);
            }
        } else if (expect instanceof String) {
            if (this.asString) {
                if (!this.asObject(actual, true).equals(expect)) {
                    this.diffMap.add(parentKey, actual, expect);
                }
            } else {
                this.diffMap.add(parentKey, actual, expect);
            }
        } else {
            Set<Method> list = Reflector.getAllGetterMethod(expect.getClass());
            for (Method method : list) {
                Object expectItem = MethodAccessor.method(method).invoke(expect, new Object[0]);
                if (expectItem == null && this.ignoreNull) {
                    this.diffMap.addIgnore();
                    continue;
                }
                String methodName = method.getName();
                Object actualItem = MethodAccessor.invoke(actual, methodName, new Object[0]);
                new DiffFactory(this).compare((Object)(parentKey + "." + this.propertyName(methodName)), actualItem, expectItem);
            }
        }
        return this.diffMap;
    }

    private void compareNumber(Object parentKey, Number actual, Object expect) {
        if (!this.asString && expect instanceof String) {
            this.diffMap.add(parentKey, actual, expect);
        } else if (expect instanceof Boolean) {
            if (!((Boolean)expect & actual.intValue() != 0)) {
                this.diffMap.add(parentKey, actual, expect);
            }
        } else {
            BigDecimal _expect;
            BigDecimal _actual = new BigDecimal(String.valueOf(actual));
            if (_actual.compareTo(_expect = new BigDecimal(String.valueOf(expect))) != 0) {
                this.diffMap.add(parentKey, actual, expect);
            }
        }
    }

    private String propertyName(String methodName) {
        if (methodName.startsWith("is")) {
            return methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
        }
        return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
    }

    private boolean isDate(Object actual) {
        if (actual instanceof Date) {
            return true;
        }
        if (actual instanceof Calendar) {
            return true;
        }
        return actual instanceof Temporal;
    }

    private void compareDate(Object parentKey, Object actual, Object expect) {
        if (this.asString || expect instanceof String) {
            String _expect = (String)this.asObject(expect, true);
            String _actual = (String)this.asObject(actual, true);
            if (!_actual.contains(_expect)) {
                this.diffMap.add(parentKey, actual, _expect);
            }
        } else if (!actual.equals(expect)) {
            this.diffMap.add(parentKey, actual, expect);
        }
    }
}

