/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.matcher.property;

import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.test4j.tools.commons.ArrayHelper;
import org.test4j.tools.commons.ListHelper;
import org.test4j.tools.reflector.PropertyAccessor;

public class PropertyItemMatcher
extends BaseMatcher {
    private final String property;
    private final Matcher matcher;
    private final StringBuilder buff = new StringBuilder();

    public PropertyItemMatcher(String property, Matcher matcher) {
        this.property = property;
        this.matcher = matcher;
        if (this.property == null) {
            throw new RuntimeException("the property can't be null.");
        }
    }

    public boolean matches(Object actual) {
        if (actual == null) {
            this.buff.append("properties equals matcher, the actual value can't be null.");
            return false;
        }
        if (ArrayHelper.isCollOrArray(actual)) {
            List list = ListHelper.toList(actual);
            List actualList = PropertyAccessor.getPropertyOfList(list, this.property, true);
            return this.matcher.matches((Object)actualList);
        }
        Object actualValue = PropertyAccessor.getPropertyByOgnl(actual, this.property, true);
        return this.matcher.matches(actualValue);
    }

    public void describeTo(Description description) {
        description.appendText("the property[" + this.property + "] of object must match");
        description.appendText(this.buff.toString());
        this.matcher.describeTo(description);
    }
}

