/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.commons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ArrayHelper {
    private static Object[] toPrimitiveArray(char[] values) {
        ArrayList<Character> objs = new ArrayList<Character>();
        char[] cArray = values;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character value = Character.valueOf(cArray[i]);
            objs.add(value);
        }
        return objs.toArray();
    }

    private static Object[] toPrimitiveArray(float[] values) {
        ArrayList<Float> objs = new ArrayList<Float>();
        float[] fArray = values;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Float value = Float.valueOf(fArray[i]);
            objs.add(value);
        }
        return objs.toArray();
    }

    private static Object[] toPrimitiveArray(long[] values) {
        ArrayList<Long> objs = new ArrayList<Long>();
        long[] lArray = values;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long value = lArray[i];
            objs.add(value);
        }
        return objs.toArray();
    }

    private static Object[] toPrimitiveArray(short[] values) {
        ArrayList<Short> objs = new ArrayList<Short>();
        short[] sArray = values;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            Short value = sArray[i];
            objs.add(value);
        }
        return objs.toArray();
    }

    private static Object[] toPrimitiveArray(int[] values) {
        ArrayList<Integer> objs = new ArrayList<Integer>();
        int[] nArray = values;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer value = nArray[i];
            objs.add(value);
        }
        return objs.toArray();
    }

    private static Object[] toPrimitiveArray(double[] values) {
        ArrayList<Double> objs = new ArrayList<Double>();
        double[] dArray = values;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double value = dArray[i];
            objs.add(value);
        }
        return objs.toArray();
    }

    private static Object[] toPrimitiveArray(boolean[] values) {
        ArrayList<Boolean> objs = new ArrayList<Boolean>();
        boolean[] blArray = values;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            Boolean value = blArray[i];
            objs.add(value);
        }
        return objs.toArray();
    }

    private static Object[] toPrimitiveArray(byte[] values) {
        ArrayList<Byte> objs = new ArrayList<Byte>();
        byte[] byArray = values;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte value = byArray[i];
            objs.add(value);
        }
        return objs.toArray();
    }

    public static Object[] asArray(Object value) {
        if (value instanceof int[]) {
            return ArrayHelper.toPrimitiveArray((int[])value);
        }
        if (value instanceof long[]) {
            return ArrayHelper.toPrimitiveArray((long[])value);
        }
        if (value instanceof short[]) {
            return ArrayHelper.toPrimitiveArray((short[])value);
        }
        if (value instanceof float[]) {
            return ArrayHelper.toPrimitiveArray((float[])value);
        }
        if (value instanceof double[]) {
            return ArrayHelper.toPrimitiveArray((double[])value);
        }
        if (value instanceof char[]) {
            return ArrayHelper.toPrimitiveArray((char[])value);
        }
        if (value instanceof byte[]) {
            return ArrayHelper.toPrimitiveArray((byte[])value);
        }
        if (value instanceof boolean[]) {
            return ArrayHelper.toPrimitiveArray((boolean[])value);
        }
        if (value instanceof Object[]) {
            return (Object[])value;
        }
        throw new RuntimeException("object isn't an array.");
    }

    public static Object[] toArray(Object ... objects) {
        if (objects == null || objects.length == 0) {
            return new Object[0];
        }
        if (objects.length == 1) {
            Object o = objects[0];
            if (o == null) {
                return new Object[]{null};
            }
            if (o.getClass().isArray()) {
                return ArrayHelper.asArray(o);
            }
            if (o instanceof Collection) {
                Collection coll = (Collection)o;
                Object[] array = new Object[coll.size()];
                int index = 0;
                for (Object item : coll) {
                    array[index++] = item;
                }
                return array;
            }
            return new Object[]{o};
        }
        Object[] array = new Object[objects.length];
        int index = 0;
        Object[] objectArray = objects;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object o;
            array[index] = o = objectArray[i];
            ++index;
        }
        return array;
    }

    public static Object[] toArray(Object o1, Object[] o2) {
        if (o2 == null || o2.length == 0) {
            return new Object[]{o1};
        }
        Object[] arr = new Object[o2.length + 1];
        arr[0] = o1;
        System.arraycopy(o2, 0, arr, 1, o2.length);
        return arr;
    }

    public static boolean isArray(Object o) {
        if (o instanceof char[]) {
            return true;
        }
        if (o instanceof boolean[]) {
            return true;
        }
        if (o instanceof byte[]) {
            return true;
        }
        if (o instanceof short[]) {
            return true;
        }
        if (o instanceof int[]) {
            return true;
        }
        if (o instanceof long[]) {
            return true;
        }
        if (o instanceof float[]) {
            return true;
        }
        if (o instanceof double[]) {
            return true;
        }
        return o instanceof Object[];
    }

    public static boolean isCollOrArray(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Collection) {
            return true;
        }
        return o.getClass().isArray();
    }

    public static int sizeOf(Object o) {
        int size;
        if (o == null) {
            return 0;
        }
        if (o instanceof Collection) {
            size = ((Collection)o).size();
        } else if (o instanceof Map) {
            size = ((Map)o).size();
        } else if (o instanceof char[]) {
            size = ((char[])o).length;
        } else if (o instanceof boolean[]) {
            size = ((boolean[])o).length;
        } else if (o instanceof byte[]) {
            size = ((byte[])o).length;
        } else if (o instanceof short[]) {
            size = ((short[])o).length;
        } else if (o instanceof int[]) {
            size = ((int[])o).length;
        } else if (o instanceof long[]) {
            size = ((long[])o).length;
        } else if (o instanceof float[]) {
            size = ((float[])o).length;
        } else if (o instanceof double[]) {
            size = ((double[])o).length;
        } else if (o instanceof Object[]) {
            size = ((Object[])o).length;
        } else {
            return 1;
        }
        return size;
    }

    public static String toString(long[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        return "[" + Stream.of(a).map(String::valueOf).collect(Collectors.joining(",")) + "]";
    }

    public static String toString(int[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        return "[" + Stream.of(a).map(String::valueOf).collect(Collectors.joining(",")) + "]";
    }

    public static String toString(short[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        return "[" + Stream.of(a).map(String::valueOf).collect(Collectors.joining(",")) + "]";
    }

    public static String toString(char[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        return "[" + Stream.of(a).map(String::valueOf).collect(Collectors.joining(",")) + "]";
    }

    public static String toString(byte[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        return "[" + Stream.of(a).map(String::valueOf).collect(Collectors.joining(",")) + "]";
    }

    public static String toString(boolean[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        return "[" + Stream.of(a).map(String::valueOf).collect(Collectors.joining(",")) + "]";
    }

    public static String toString(float[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        return "[" + Stream.of(a).map(String::valueOf).collect(Collectors.joining(",")) + "]";
    }

    public static String toString(double[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        return "[" + Stream.of(a).map(String::valueOf).collect(Collectors.joining(",")) + "]";
    }

    public static String toString(Object[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        return "[" + Stream.of(a).map(String::valueOf).collect(Collectors.joining(",")) + "]";
    }

    public static String toString(Object array) {
        if (array == null) {
            return "[]";
        }
        if (array instanceof long[]) {
            return ArrayHelper.toString((long[])array);
        }
        if (array instanceof int[]) {
            return ArrayHelper.toString((int[])array);
        }
        if (array instanceof short[]) {
            return ArrayHelper.toString((short[])array);
        }
        if (array instanceof char[]) {
            return ArrayHelper.toString((char[])array);
        }
        if (array instanceof byte[]) {
            return ArrayHelper.toString((byte[])array);
        }
        if (array instanceof boolean[]) {
            return ArrayHelper.toString((boolean[])array);
        }
        if (array instanceof float[]) {
            return ArrayHelper.toString((float[])array);
        }
        if (array instanceof double[]) {
            return ArrayHelper.toString((double[])array);
        }
        if (array instanceof Object[]) {
            return ArrayHelper.toString((Object[])array);
        }
        return array.toString();
    }

    public static boolean isSameLength(Object[] array1, Object[] array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return false;
        }
        return array1.length == array2.length;
    }

    public static List arr(Object value, Object ... values) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (values != null && values.length == 0) {
            if (value instanceof Collection) {
                list.addAll((Collection)value);
                return list;
            }
            if (value != null && value.getClass().isArray()) {
                Object[] arr = ArrayHelper.asArray(value);
                list.addAll(Arrays.asList(arr));
                return list;
            }
        }
        list.add(value);
        if (values == null) {
            list.add(null);
        } else {
            list.addAll(Arrays.asList(values));
        }
        return list;
    }
}

