/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.commons;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.test4j.tools.commons.StringHelper;

public class DateHelper {
    static final SimpleDateFormat df_default = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    static final SimpleDateFormat df_datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static final SimpleDateFormat df_time = new SimpleDateFormat("HH:mm:ss");
    static final SimpleDateFormat df_date = new SimpleDateFormat("yyyy-MM-dd");

    public static String currDateStr() {
        return DateHelper.toDateTimeStr(DateHelper.now(), "yyyy-MM-dd");
    }

    public static String currDateTimeStr() {
        return DateHelper.toDateTimeStr(DateHelper.now(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String currDateTimeStr(String format) {
        return DateHelper.toDateTimeStr(DateHelper.now(), format);
    }

    public static String toDateTimeStr(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static Date now() {
        return new Date();
    }

    public static SimpleDateFormat getDateFormat(String input) {
        if (input == null) {
            return df_default;
        }
        if (input.matches("\\s*\\d{4}-\\d{1,2}-\\d{1,2}\\s*")) {
            return df_date;
        }
        if (input.matches("\\s*\\d{2,4}-\\d{1,2}-\\d{1,2}\\s+\\d{1,2}:\\d{1,2}:\\d{1,2}\\s*")) {
            return df_datetime;
        }
        if (input.matches("\\s*\\d{1,2}:\\d{1,2}:\\d{1,2}\\s*")) {
            return df_time;
        }
        return df_default;
    }

    public static Date parse(String str) {
        Date date;
        if (StringHelper.isBlank(str)) {
            throw new RuntimeException("parse date string can't be empty.");
        }
        try {
            SimpleDateFormat df = DateHelper.getDateFormat(str);
            date = df.parse(str);
        }
        catch (Throwable e) {
            String error = "can't parse datetime from string[" + str + "].";
            throw new RuntimeException(error, e);
        }
        if (date == null) {
            throw new RuntimeException("can't parse datetime from string[" + str + "].");
        }
        return date;
    }
}

