/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.datagen;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;
import java.util.UUID;
import org.test4j.tools.datagen.DataGenerator;

public class RandomDataGenerator
extends DataGenerator {
    private static final Random random = new Random(System.currentTimeMillis());
    private final Class type;

    public RandomDataGenerator(Class type) {
        this.type = type;
    }

    @Override
    public Object generate(int index) {
        if (this.type == Integer.class || this.type == Integer.TYPE) {
            return random.nextInt();
        }
        if (this.type == Long.class || this.type == Long.TYPE) {
            return random.nextLong();
        }
        if (this.type == Short.class || this.type == Short.TYPE) {
            String value = String.valueOf(random.nextInt());
            return Short.valueOf(value);
        }
        if (this.type == Double.class || this.type == Double.TYPE) {
            return random.nextDouble();
        }
        if (this.type == Float.class || this.type == Float.TYPE) {
            return Float.valueOf(random.nextFloat());
        }
        if (this.type == Boolean.class || this.type == Boolean.TYPE) {
            return random.nextBoolean();
        }
        if (this.type == BigDecimal.class) {
            return BigDecimal.valueOf(random.nextDouble());
        }
        if (this.type == BigInteger.class) {
            return BigDecimal.valueOf(random.nextLong());
        }
        if (this.type == String.class) {
            return UUID.randomUUID().toString();
        }
        throw new RuntimeException("unsupport this type random generate, only support type[Number, String, BigInteger, BigDecimal].");
    }
}

