/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.reflector;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.test4j.tools.commons.ClazzHelper;
import org.test4j.tools.reflector.Reflector;

public class FieldAccessor {
    private final Field field;
    private final String declaringClass;
    private final String fieldName;

    private FieldAccessor(Class klass, String fieldName) {
        if (fieldName == null || klass == null) {
            throw new NullPointerException("to get a field, the class type or field name can't be null.");
        }
        this.field = Reflector.getField(klass, fieldName);
        this.declaringClass = klass.getName();
        this.fieldName = fieldName;
    }

    private FieldAccessor(Object target, String fieldName) {
        if (fieldName == null || target == null) {
            throw new NullPointerException("to get a field, the target or field name can't be null.");
        }
        Object _target = ClazzHelper.getProxiedObject(target);
        Class<?> klass = _target.getClass();
        this.field = Reflector.getField(klass, fieldName);
        this.declaringClass = klass.getName();
        this.fieldName = fieldName;
    }

    private FieldAccessor(Field field) {
        if (field == null) {
            throw new NullPointerException("to get a field, the target or field name can't be null.");
        }
        this.field = field;
        this.declaringClass = field.getDeclaringClass().getName();
        this.fieldName = field.getName();
    }

    public Class getFieldType() {
        return this.field.getType();
    }

    public Type getFieldGenericType() {
        return this.field.getGenericType();
    }

    public final <T> T get(Object target) {
        boolean isAccessible = this.field.isAccessible();
        try {
            this.field.setAccessible(true);
            Object object = this.field.get(target);
            return (T)object;
        }
        catch (Exception e) {
            String info = String.format("to get field[%s] value from class[%s] error.", this.fieldName, this.declaringClass);
            throw new RuntimeException(info, e);
        }
        finally {
            this.field.setAccessible(isAccessible);
        }
    }

    public final <T> T getStatic() {
        if (!Modifier.isStatic(this.field.getModifiers())) {
            throw new IllegalArgumentException("Field " + this.fieldName + " is not static");
        }
        return this.get(null);
    }

    public final void set(Object target, Object value) {
        boolean isAccessible = this.field.isAccessible();
        try {
            Object _target = ClazzHelper.getProxiedObject(target);
            this.field.setAccessible(true);
            this.field.set(_target, value);
        }
        catch (Exception e) {
            String info = String.format("to set field[%s] value into target[%s] error.", this.fieldName, this.declaringClass);
            throw new RuntimeException(info, e);
        }
        finally {
            this.field.setAccessible(isAccessible);
        }
    }

    public final void setStatic(Object value) {
        if (!Modifier.isStatic(this.field.getModifiers())) {
            throw new IllegalArgumentException("Field " + this.fieldName + " is not static");
        }
        this.set(null, value);
    }

    public static FieldAccessor field(Class klass, String fieldName) {
        return new FieldAccessor(klass, fieldName);
    }

    public static FieldAccessor field(Object target, String fieldName) {
        return new FieldAccessor(target, fieldName);
    }

    public static FieldAccessor field(Field field) {
        return new FieldAccessor(field);
    }

    public static Object getValue(Object target, String field) {
        return new FieldAccessor(target, field).get(target);
    }

    public static void setValue(Object target, String field, Object value) {
        new FieldAccessor(target, field).set(target, value);
    }

    public static Object getValue(Class clazz, String field) {
        return new FieldAccessor(clazz, field).getStatic();
    }

    public static void setValue(Class clazz, String field, Object value) {
        new FieldAccessor(clazz, field).setStatic(value);
    }

    public Field getField() {
        return this.field;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }
}

