/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity5.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.web.server.ServerWebExchange;
import org.thymeleaf.context.IContext;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.expression.IExpressionObjects;
import org.thymeleaf.extras.springsecurity5.util.ISpringVersionSpecificUtility;
import org.thymeleaf.extras.springsecurity5.util.SpringVersionUtils;
import org.thymeleaf.util.ClassLoaderUtils;

public final class SpringVersionSpecificUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SpringVersionSpecificUtils.class);
    private static final String PACKAGE_NAME = SpringVersionSpecificUtils.class.getPackage().getName();
    private static final String SPRING5_DELEGATE_CLASS = PACKAGE_NAME + ".Spring5VersionSpecificUtility";
    private static final ISpringVersionSpecificUtility spring5Delegate;

    public static EvaluationContext wrapEvaluationContext(EvaluationContext evaluationContext, IExpressionObjects expresionObjects) {
        if (spring5Delegate != null) {
            return spring5Delegate.wrapEvaluationContext(evaluationContext, expresionObjects);
        }
        throw new ConfigurationException("The authorization infrastructure could not create initializer for the specific version of Spring beingused. Currently only Spring 5.x or newer is supported.");
    }

    public static boolean isWebContext(IContext context) {
        if (spring5Delegate != null) {
            return spring5Delegate.isWebContext(context);
        }
        throw new ConfigurationException("The authorization infrastructure could not create initializer for the specific version of Spring beingused. Currently only Spring 5.x or newer is supported.");
    }

    public static boolean isWebMvcContext(IContext context) {
        if (spring5Delegate != null) {
            return spring5Delegate.isWebMvcContext(context);
        }
        throw new ConfigurationException("The authorization infrastructure could not create initializer for the specific version of Spring beingused. Currently only Spring 5.x or newer is supported.");
    }

    public static boolean isWebFluxContext(IContext context) {
        if (spring5Delegate != null) {
            return spring5Delegate.isWebFluxContext(context);
        }
        throw new ConfigurationException("The authorization infrastructure could not create initializer for the specific version of Spring beingused. Currently only Spring 5.x or newer is supported.");
    }

    public static HttpServletRequest getHttpServletRequest(IContext context) {
        if (spring5Delegate != null) {
            return spring5Delegate.getHttpServletRequest(context);
        }
        throw new ConfigurationException("The authorization infrastructure could not create initializer for the specific version of Spring beingused. Currently only Spring 5.x or newer is supported.");
    }

    public static HttpServletResponse getHttpServletResponse(IContext context) {
        if (spring5Delegate != null) {
            return spring5Delegate.getHttpServletResponse(context);
        }
        throw new ConfigurationException("The authorization infrastructure could not create initializer for the specific version of Spring beingused. Currently only Spring 5.x or newer is supported.");
    }

    public static ServerWebExchange getServerWebExchange(IContext context) {
        if (spring5Delegate != null) {
            return spring5Delegate.getServerWebExchange(context);
        }
        throw new ConfigurationException("The authorization infrastructure could not create initializer for the specific version of Spring beingused. Currently only Spring 5.x or newer is supported.");
    }

    private SpringVersionSpecificUtils() {
    }

    static {
        if (SpringVersionUtils.isSpring50AtLeast()) {
            LOG.trace("[THYMELEAF][TESTING] Spring 5.0+ found on classpath. Initializing version-specific utilities for Spring 5");
            try {
                Class implClass = ClassLoaderUtils.loadClass((String)SPRING5_DELEGATE_CLASS);
                spring5Delegate = (ISpringVersionSpecificUtility)implClass.newInstance();
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError((Throwable)new ConfigurationException("Environment has been detected to be at least Spring 5, but thymeleaf could not initialize a delegate of class \"" + SPRING5_DELEGATE_CLASS + "\"", (Throwable)e));
            }
        } else {
            throw new ExceptionInInitializerError((Throwable)new ConfigurationException("The Spring-version-specific infrastructure could not create utility for the specific version of Spring being used. Currently only Spring 5.x or newer is supported."));
        }
    }
}

