/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity6.auth;

import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.core.Authentication;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.extras.springsecurity6.auth.AclAuthUtils;
import org.thymeleaf.extras.springsecurity6.auth.AuthUtils;
import org.thymeleaf.util.Validate;

public final class AclAuthorization {
    private final IExpressionContext context;
    private final Authentication authentication;

    public AclAuthorization(IExpressionContext context, Authentication authentication) {
        this.context = context;
        this.authentication = authentication;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public boolean acl(Object domainObject, String permissions) {
        Validate.notEmpty((String)permissions, (String)"permissions cannot be null or empty");
        ApplicationContext applicationContext = AuthUtils.getContext((IContext)this.context);
        List<Permission> permissionsList = AclAuthUtils.parsePermissionsString(applicationContext, permissions);
        return AclAuthUtils.authorizeUsingAccessControlList(this.context, domainObject, permissionsList, this.authentication);
    }
}

