/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnlook;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.AbstractSVNCommandEnvironment;
import org.tmatesoft.svn.cli.AbstractSVNOption;
import org.tmatesoft.svn.cli.SVNCommandLine;
import org.tmatesoft.svn.cli.SVNOptionValue;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import org.tmatesoft.svn.cli.svnlook.SVNLookOption;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNLookCommandEnvironment
extends AbstractSVNCommandEnvironment {
    private long myRevision = -1L;
    private String myTransaction;
    private boolean myIsNonRecursive;
    private boolean myIsVerbose;
    private boolean myIsHelp;
    private boolean myIsRevProp;
    private boolean myIsVersion;
    private boolean myIsShowIDs;
    private long myLimit;
    private boolean myIsNoDiffDeleted;
    private boolean myIsNoDiffAdded;
    private boolean myIsDiffCopyFrom;
    private boolean myIsFullPaths;
    private boolean myIsCopyInfo;
    private Collection myExtensions = new SVNHashSet();
    private boolean myIsRevision;
    private File myRepositoryFile;
    private FSRepository myRepository;
    private FSTransactionInfo myTransactionInfo;
    private String myArgument1;
    private String myArgument2;

    public SVNLookCommandEnvironment(String programName, PrintStream out, PrintStream err, InputStream in) {
        super(programName, out, err, in);
    }

    public File getRepositoryFile() {
        return this.myRepositoryFile;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public String getTransaction() {
        return this.myTransaction;
    }

    public boolean isNonRecursive() {
        return this.myIsNonRecursive;
    }

    public boolean isVerbose() {
        return this.myIsVerbose;
    }

    public boolean isHelp() {
        return this.myIsHelp;
    }

    public boolean isRevProp() {
        return this.myIsRevProp;
    }

    public boolean isVersion() {
        return this.myIsVersion;
    }

    public boolean isShowIDs() {
        return this.myIsShowIDs;
    }

    public long getLimit() {
        return this.myLimit;
    }

    public boolean isNoDiffDeleted() {
        return this.myIsNoDiffDeleted;
    }

    public boolean isNoDiffAdded() {
        return this.myIsNoDiffAdded;
    }

    public boolean isDiffCopyFrom() {
        return this.myIsDiffCopyFrom;
    }

    public boolean isFullPaths() {
        return this.myIsFullPaths;
    }

    public boolean isCopyInfo() {
        return this.myIsCopyInfo;
    }

    public Collection getExtensions() {
        return this.myExtensions;
    }

    public boolean isRevision() {
        return this.myIsRevision;
    }

    public FSTransactionInfo getTransactionInfo() {
        return this.myTransactionInfo;
    }

    public FSRepository getRepository() {
        return this.myRepository;
    }

    public String getFirstArgument() {
        return this.myArgument1;
    }

    public String getSecondArgument() {
        return this.myArgument2;
    }

    @Override
    protected ISVNAuthenticationManager createClientAuthenticationManager() {
        return SVNWCUtil.createDefaultAuthenticationManager();
    }

    @Override
    protected DefaultSVNOptions createClientOptions() {
        return SVNWCUtil.createDefaultOptions((boolean)true);
    }

    @Override
    protected void validateOptions(SVNCommandLine commandLine) throws SVNException {
        SVNErrorMessage err;
        super.validateOptions(commandLine);
        if (this.myRevision >= 0L && this.myTransaction != null) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, (String)"The '--transaction' (-t) and '--revision' (-r) arguments can not co-exist");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        boolean bl = this.myIsRevision = this.myTransaction == null;
        if (!(this.myIsHelp || this.myIsVersion || "help".equals(commandLine.getCommandName()))) {
            SVNPath path;
            if (this.getArguments().isEmpty()) {
                err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Repository argument required");
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            if ((path = new SVNPath((String)this.getArguments().get(0), false)).isURL()) {
                SVNErrorMessage err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"''{0}'' is URL when it should be a path", (Object)path.getTarget());
                SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
            }
            this.myRepositoryFile = path.getFile();
            this.myRepository = (FSRepository)SVNRepositoryFactory.create((SVNURL)SVNURL.fromFile((File)this.myRepositoryFile));
            this.myRepository.setCanceller((ISVNCanceller)this);
            this.myRepository.testConnection();
            if (this.getTransaction() != null) {
                this.myTransactionInfo = this.myRepository.getFSFS().openTxn(this.getTransaction());
            } else if (this.myRevision < 0L) {
                this.myRevision = this.myRepository.getLatestRevision();
            }
            LinkedList updatedArguments = new LinkedList(this.getArguments());
            updatedArguments.remove(0);
            if (!updatedArguments.isEmpty()) {
                this.myArgument1 = (String)updatedArguments.remove(0);
            }
            if (!updatedArguments.isEmpty()) {
                this.myArgument2 = (String)updatedArguments.remove(0);
            }
            this.setArguments(updatedArguments);
        }
    }

    @Override
    protected void initOption(SVNOptionValue optionValue) throws SVNException {
        AbstractSVNOption option = optionValue.getOption();
        if (option == SVNLookOption.REVISION) {
            long revision = -1L;
            if (optionValue.getValue() != null) {
                try {
                    revision = Long.parseLong(optionValue.getValue());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (revision < 0L) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Invalid revision number supplied");
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            this.myRevision = revision;
        } else if (option == SVNLookOption.TRANSACTION) {
            this.myTransaction = optionValue.getValue();
        } else if (option == SVNLookOption.NON_RECURSIVE) {
            this.myIsNonRecursive = true;
        } else if (option == SVNLookOption.VERBOSE) {
            this.myIsVerbose = true;
        } else if (option == SVNLookOption.HELP || option == SVNLookOption.QUESTION) {
            this.myIsHelp = true;
        } else if (option == SVNLookOption.REVPROP) {
            this.myIsRevProp = true;
        } else if (option == SVNLookOption.VERSION) {
            this.myIsVersion = true;
        } else if (option == SVNLookOption.SHOW_IDS) {
            this.myIsShowIDs = true;
        } else if (option == SVNLookOption.LIMIT) {
            SVNErrorMessage err;
            long limit = -1L;
            if (optionValue.getValue() != null) {
                try {
                    limit = Long.parseLong(optionValue.getValue());
                }
                catch (NumberFormatException nfe) {
                    SVNErrorMessage err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Non-numeric limit argument given");
                    SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
                }
            } else {
                err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Non-numeric limit argument given");
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            if (limit <= 0L) {
                err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Argument to --limit must be positive");
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            this.myLimit = limit;
        } else if (option == SVNLookOption.NO_DIFF_DELETED) {
            this.myIsNoDiffDeleted = true;
        } else if (option == SVNLookOption.NO_DIFF_ADDED) {
            this.myIsNoDiffAdded = true;
        } else if (option == SVNLookOption.DIFF_COPY_FROM) {
            this.myIsDiffCopyFrom = true;
        } else if (option == SVNLookOption.FULL_PATHS) {
            this.myIsFullPaths = true;
        } else if (option == SVNLookOption.COPY_INFO) {
            this.myIsCopyInfo = true;
        } else if (option == SVNLookOption.EXTENSIONS) {
            this.myExtensions.add(optionValue.getValue());
        }
    }

    public SVNDiffOptions getDiffOptions() throws SVNException {
        boolean ignoreEOLStyle;
        boolean ignoreAmountOfWS;
        boolean ignoreAllWS;
        LinkedList extensions = new LinkedList(this.myExtensions);
        boolean bl = ignoreAllWS = this.myExtensions.contains("-w") || this.myExtensions.contains("--ignore-all-space");
        if (ignoreAllWS) {
            extensions.remove("-w");
            extensions.remove("--ignore-all-space");
        }
        boolean bl2 = ignoreAmountOfWS = this.myExtensions.contains("-b") || this.myExtensions.contains("--ignore-space-change");
        if (ignoreAmountOfWS) {
            extensions.remove("-b");
            extensions.remove("--ignore-space-change");
        }
        if (ignoreEOLStyle = this.myExtensions.contains("--ignore-eol-style")) {
            extensions.remove("--ignore-eol-style");
        }
        if (!extensions.isEmpty()) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.INVALID_DIFF_OPTION, (String)"Invalid argument ''{0}'' in diff options", extensions.get(0));
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        return new SVNDiffOptions(ignoreAllWS, ignoreAmountOfWS, ignoreEOLStyle);
    }

    @Override
    protected String refineCommandName(String commandName, SVNCommandLine commandLine) throws SVNException {
        Iterator options = commandLine.optionValues();
        while (options.hasNext()) {
            SVNOptionValue optionValue = (SVNOptionValue)options.next();
            AbstractSVNOption option = optionValue.getOption();
            if (option == SVNLookOption.HELP || option == SVNLookOption.QUESTION) {
                this.myIsHelp = true;
                continue;
            }
            if (option != SVNLookOption.VERSION) continue;
            this.myIsVersion = true;
        }
        if (this.myIsHelp) {
            List<String> newArguments = commandName != null ? Collections.singletonList(commandName) : Collections.EMPTY_LIST;
            this.setArguments(newArguments);
            return "help";
        }
        if (commandName == null) {
            if (this.myIsVersion) {
                SVNLookCommand versionCommand = new SVNLookCommand("--version", null){

                    @Override
                    protected Collection createSupportedOptions() {
                        LinkedList<SVNLookOption> options = new LinkedList<SVNLookOption>();
                        options.add(SVNLookOption.VERSION);
                        return options;
                    }

                    @Override
                    public void run() throws SVNException {
                        AbstractSVNCommand helpCommand = AbstractSVNCommand.getCommand("help");
                        helpCommand.init(SVNLookCommandEnvironment.this);
                        helpCommand.run();
                    }
                };
                AbstractSVNCommand.registerCommand(versionCommand);
                return "--version";
            }
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Subcommand argument required");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        return commandName;
    }

    @Override
    protected String getCommandLineClientName() {
        return "svnlook";
    }
}

