/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.uncommons.watchmaker.framework.AbstractEvolutionEngine;
import org.uncommons.watchmaker.framework.CandidateFactory;
import org.uncommons.watchmaker.framework.EvaluatedCandidate;
import org.uncommons.watchmaker.framework.EvolutionaryOperator;
import org.uncommons.watchmaker.framework.FitnessEvaluator;
import org.uncommons.watchmaker.framework.NullFitnessEvaluator;
import org.uncommons.watchmaker.framework.SelectionStrategy;
import org.uncommons.watchmaker.framework.interactive.InteractiveSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequentialEvolutionEngine<T>
extends AbstractEvolutionEngine<T> {
    public SequentialEvolutionEngine(CandidateFactory<T> candidateFactory, EvolutionaryOperator<T> evolutionScheme, FitnessEvaluator<? super T> fitnessEvaluator, SelectionStrategy<? super T> selectionStrategy, Random rng) {
        super(candidateFactory, evolutionScheme, fitnessEvaluator, selectionStrategy, rng);
    }

    public SequentialEvolutionEngine(CandidateFactory<T> candidateFactory, EvolutionaryOperator<T> evolutionScheme, InteractiveSelection<T> selectionStrategy, Random rng) {
        this(candidateFactory, evolutionScheme, new NullFitnessEvaluator(), selectionStrategy, rng);
    }

    @Override
    protected List<EvaluatedCandidate<T>> evaluatePopulation(List<T> population) {
        ArrayList<EvaluatedCandidate<T>> evaluatedPopulation = new ArrayList<EvaluatedCandidate<T>>(population.size());
        for (T candidate : population) {
            evaluatedPopulation.add(new EvaluatedCandidate<T>(candidate, this.getFitnessEvaluator().getFitness(candidate, population)));
        }
        return evaluatedPopulation;
    }
}

