/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.uncommons.maths.number.ConstantGenerator;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.Probability;
import org.uncommons.watchmaker.framework.EvolutionaryOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCrossover<T>
implements EvolutionaryOperator<T> {
    private final NumberGenerator<Integer> crossoverPointsVariable;
    private final NumberGenerator<Probability> crossoverProbabilityVariable;

    protected AbstractCrossover(int crossoverPoints) {
        this(crossoverPoints, Probability.ONE);
    }

    protected AbstractCrossover(int crossoverPoints, Probability crossoverProbability) {
        this((NumberGenerator<Integer>)new ConstantGenerator((Number)crossoverPoints), (NumberGenerator<Probability>)new ConstantGenerator((Number)crossoverProbability));
        if (crossoverPoints <= 0) {
            throw new IllegalArgumentException("Number of cross-over points must be positive.");
        }
    }

    protected AbstractCrossover(NumberGenerator<Integer> crossoverPointsVariable) {
        this(crossoverPointsVariable, (NumberGenerator<Probability>)new ConstantGenerator((Number)Probability.ONE));
    }

    protected AbstractCrossover(NumberGenerator<Integer> crossoverPointsVariable, NumberGenerator<Probability> crossoverProbabilityVariable) {
        this.crossoverPointsVariable = crossoverPointsVariable;
        this.crossoverProbabilityVariable = crossoverProbabilityVariable;
    }

    @Override
    public List<T> apply(List<T> selectedCandidates, Random rng) {
        ArrayList<T> selectionClone = new ArrayList<T>(selectedCandidates);
        Collections.shuffle(selectionClone, rng);
        ArrayList result = new ArrayList(selectedCandidates.size());
        Iterator iterator = selectionClone.iterator();
        while (iterator.hasNext()) {
            Object parent1 = iterator.next();
            if (iterator.hasNext()) {
                int crossoverPoints;
                Object parent2 = iterator.next();
                int n = crossoverPoints = ((Probability)this.crossoverProbabilityVariable.nextValue()).nextEvent(rng) ? (Integer)this.crossoverPointsVariable.nextValue() : 0;
                if (crossoverPoints > 0) {
                    result.addAll(this.mate(parent1, parent2, crossoverPoints, rng));
                    continue;
                }
                result.add(parent1);
                result.add(parent2);
                continue;
            }
            result.add(parent1);
        }
        return result;
    }

    protected abstract List<T> mate(T var1, T var2, int var3, Random var4);
}

