/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.codegen;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.Arg;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.unidal.helper.Files;
import org.unidal.helper.Joiners;
import org.unidal.helper.Splitters;
import org.unidal.lookup.configuration.AbstractResourceConfigurator;

public class PlexusMojo
extends AbstractMojo {
    protected MavenProject m_project;
    protected String className;
    protected String env;
    protected boolean verbose;
    protected boolean debug;
    protected boolean skip;

    private String buildClasspath(List<String> elements) {
        String os;
        String path = Joiners.by((String)System.getProperty("path.separator")).join(elements);
        if (path.length() >= 2000 && (os = System.getProperty("os.name")).toLowerCase().contains("windows")) {
            StringBuilder sb = new StringBuilder(2048);
            char sp = File.pathSeparatorChar;
            File tmpDir = new File("target/tmplib");
            int index = 0;
            Files.forDir().delete(tmpDir, true);
            tmpDir.mkdirs();
            for (String element : elements) {
                File source = new File(element);
                if (sb.length() > 0) {
                    sb.append(sp);
                }
                if (source.isFile()) {
                    try {
                        File target = new File(tmpDir, index++ + ".jar");
                        Files.forDir().copyFile(source, target);
                        sb.append(target.getCanonicalPath());
                        target.deleteOnExit();
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println(e);
                    }
                }
                sb.append(element);
            }
            return sb.toString();
        }
        return path;
    }

    protected Map<String, String> buildProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        Properties userProperties = this.m_project.getProjectBuildingRequest().getUserProperties();
        if (userProperties != null) {
            for (Map.Entry<Object, Object> e : userProperties.entrySet()) {
                properties.put((String)e.getKey(), (String)e.getValue());
            }
        }
        return properties;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Model codegen was skipped explicitly.");
            return;
        }
        if (this.debug) {
            this.verbose = true;
        }
        try {
            List names = Splitters.by((char)',').noEmptyItem().trim().split(this.className);
            List classpathElements = this.m_project.getCompileClasspathElements();
            ClassLoader classLoader = this.makeClassLoader(classpathElements);
            String classpath = this.buildClasspath(classpathElements);
            if (this.verbose) {
                this.getLog().info((CharSequence)("Configurator: " + this.className));
                this.getLog().info((CharSequence)("Classpath: " + classpath));
            }
            Thread.currentThread().setContextClassLoader(classLoader);
            for (String name : names) {
                Class<?> clazz;
                if (this.debug) {
                    this.getLog().info((CharSequence)("Configurator: " + name));
                }
                if ((clazz = classLoader.loadClass(name)) == null) {
                    throw new MojoExecutionException(String.format("Configurator(%s) is not found!", name));
                }
                if (AbstractResourceConfigurator.class.isAssignableFrom(clazz)) {
                    this.runJavaApplication(classpath, name, this.buildProperties());
                    continue;
                }
                throw new MojoExecutionException(String.format("Class(%s) is not extended from %s.", name, AbstractResourceConfigurator.class));
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error when generating plexus components descriptor!", e);
        }
    }

    protected ClassLoader makeClassLoader(List<String> classpathElements) {
        ArrayList<URL> urls = new ArrayList<URL>(classpathElements.size());
        try {
            for (String element : classpathElements) {
                File file = new File(element);
                urls.add(file.toURI().toURL());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new URLClassLoader(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
    }

    protected void runJavaApplication(String classpath, String application, Map<String, String> properties) throws MojoExecutionException {
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(this.m_project.getBasedir());
        cli.setExecutable("java");
        StringBuilder sb = new StringBuilder(4096);
        if (classpath != null) {
            sb.append("-cp \"").append(classpath).append("\" ");
        }
        for (Map.Entry<String, String> e : properties.entrySet()) {
            String name = e.getKey();
            String value = e.getValue();
            sb.append("-D").append(name).append("=");
            if (value.indexOf(32) >= 0) {
                sb.append("\"").append(value).append("\"");
            } else {
                sb.append(value);
            }
            sb.append(' ');
        }
        sb.append(application);
        Arg arg = cli.createArg();
        arg.setLine(sb.toString());
        if (this.debug) {
            this.getLog().info((CharSequence)("Executing java " + sb));
        }
        try {
            CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)new StreamConsumer(){

                public void consumeLine(String line) {
                    PlexusMojo.this.getLog().info((CharSequence)line);
                }
            }, (StreamConsumer)new StreamConsumer(){

                public void consumeLine(String line) {
                    PlexusMojo.this.getLog().error((CharSequence)line);
                }
            });
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Fail to execute command!", (Exception)((Object)e));
        }
    }
}

