/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.converter;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.unidal.webres.converter.Converter;
import org.unidal.webres.converter.ConverterManager;
import org.unidal.webres.converter.ConverterSkippedException;
import org.unidal.webres.converter.TypeUtil;

public class ConverterContext {
    public static final String OVERRIDE = "override";
    private static final InheritableThreadLocal<Map<String, Object>> s_threadLocalData = new InheritableThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    public static final ConverterSkippedException SKIP = new ConverterSkippedException();
    private Object m_source;
    private Class<?> m_sourceClass;
    private Type m_targetType;
    private Class<?> m_targetClass;
    private Map<Converter<?>, Exception> m_converters;
    private ConverterManager m_manager;
    private boolean m_customized;

    public static <T> T getThreadLocal(String name) {
        return (T)((Map)s_threadLocalData.get()).get(name);
    }

    public static boolean isOverride() {
        Object override = ConverterContext.getThreadLocal(OVERRIDE);
        return override != null && Boolean.valueOf(override.toString()) != false;
    }

    public static void setThreadLocal(String name, Object value) {
        ((Map)s_threadLocalData.get()).put(name, value);
    }

    public ConverterContext(Object source, Type targetType, ConverterManager manager) {
        this.m_source = source;
        this.m_sourceClass = source.getClass();
        this.m_targetType = targetType;
        this.m_targetClass = TypeUtil.getRawType(targetType);
        this.m_manager = manager;
    }

    public void addConverterException(Converter<?> converter, Exception e) {
        if (this.m_converters == null) {
            this.m_converters = new LinkedHashMap();
        }
        this.m_converters.put(converter, e);
    }

    public Map<Converter<?>, Exception> getConverters() {
        return this.m_converters;
    }

    public ConverterManager getManager() {
        return this.m_manager;
    }

    public Object getSource() {
        return this.m_source;
    }

    public Class<?> getSourceClass() {
        return this.m_sourceClass;
    }

    public Class<?> getTargetClass() {
        return this.m_targetClass;
    }

    public Type getTargetType() {
        return this.m_targetType;
    }

    public boolean isCustomized() {
        return this.m_customized;
    }

    public void setCustomized(boolean customized) {
        this.m_customized = customized;
    }
}

