/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.converter;

import java.util.Map;
import org.unidal.webres.converter.Converter;
import org.unidal.webres.converter.ConverterContext;
import org.unidal.webres.dom.ITagNode;

public class ConverterException
extends RuntimeException {
    private static final long serialVersionUID = 7967709318556423946L;
    private transient ConverterContext m_ctx;

    public ConverterException(ConverterContext ctx) {
        this.m_ctx = ctx;
    }

    public ConverterException(String message) {
        super(message);
    }

    public ConverterException(String message, Throwable cause) {
        super(message, cause);
    }

    public ConverterException(Throwable cause) {
        super(cause);
    }

    public ConverterContext getCtx() {
        return this.m_ctx;
    }

    @Override
    public String getMessage() {
        if (this.m_ctx != null) {
            StringBuilder sb = new StringBuilder();
            this.getMessage(this.m_ctx, "", sb);
            return sb.toString();
        }
        return super.getMessage();
    }

    private void getMessage(ConverterContext ctx, String ctxSource, StringBuilder sb) {
        Map<Converter<?>, Exception> map;
        Object source = ctx.getSource();
        if (source instanceof ITagNode) {
            ctxSource = !ctxSource.equals("") ? String.valueOf(ctxSource) + "\\" + ((ITagNode)source).getNodeName() : ((ITagNode)source).getNodeName();
        }
        String errorCtx = "";
        if (!ctxSource.equals("")) {
            errorCtx = "[" + ctxSource + "]";
        }
        if ((map = ctx.getConverters()) != null) {
            for (Map.Entry<Converter<?>, Exception> e : map.entrySet()) {
                Exception exception = e.getValue();
                if (exception instanceof ConverterException) {
                    ConverterContext exceptionCtx = ((ConverterException)exception).getCtx();
                    if (exceptionCtx != null) {
                        this.getMessage(exceptionCtx, ctxSource, sb);
                        continue;
                    }
                    sb.append("\r\n" + errorCtx + " " + exception.toString());
                    continue;
                }
                if (exception == null) continue;
                sb.append("\r\n" + errorCtx + " " + exception.toString());
            }
        }
    }
}

