/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.converter;

import java.lang.reflect.TypeVariable;
import java.util.List;
import org.unidal.webres.converter.Converter;
import org.unidal.webres.converter.ConverterContext;
import org.unidal.webres.converter.ConverterException;
import org.unidal.webres.converter.IConverterHandler;

public class ConverterHandler
implements IConverterHandler {
    @Override
    public Object convert(ConverterContext ctx) throws ConverterException {
        Class<?> sourceClass;
        Class<?> targetClass = ctx.getTargetClass();
        if (targetClass.isAssignableFrom(sourceClass = ctx.getSourceClass()) && !(ctx.getTargetType() instanceof TypeVariable)) {
            return ctx.getSource();
        }
        List<Converter<?>> converters = ctx.getManager().getRegistry().findConverters(ctx);
        for (Converter<?> converter : converters) {
            try {
                Object value = converter.convert(ctx);
                return value;
            }
            catch (Exception e) {
                ctx.addConverterException(converter, e);
            }
        }
        throw new ConverterException(ctx);
    }
}

