/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.converter;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.webres.converter.Converter;
import org.unidal.webres.converter.ConverterContext;
import org.unidal.webres.converter.ConverterException;
import org.unidal.webres.converter.ConverterPriority;
import org.unidal.webres.converter.IRefConverter;
import org.unidal.webres.converter.TypeUtil;

public class ConverterRegistry {
    private volatile Map<Class<?>, ConverterEntry> m_converterMap = new HashMap();
    private Map<Class<?>, Class<?>> m_typeMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Converter<?>> findConverters(ConverterContext ctx) {
        ConverterEntry entry;
        List<Converter<?>> converters;
        boolean isClass = ctx.getTargetType() instanceof Class;
        Class<?> fromClass = ctx.getSourceClass();
        Class<?> targetClass = ctx.getTargetClass();
        if (isClass && targetClass.isPrimitive()) {
            targetClass = TypeUtil.getWrapClass(targetClass);
        }
        List<Converter<?>> list = converters = (entry = this.m_converterMap.get(targetClass)) == null ? null : entry.getCacheConverters(fromClass);
        if (converters == null) {
            converters = new ArrayList(5);
            if (isClass && targetClass.isArray()) {
                this.getConverters(ctx, converters, Array.class);
            } else {
                if (targetClass != Object.class) {
                    this.getConverters(ctx, converters, targetClass);
                }
                this.getConverters(ctx, converters, Type.class);
            }
            this.sortConverters(converters);
            Map<Class<?>, ConverterEntry> map = this.m_converterMap;
            synchronized (map) {
                entry = this.m_converterMap.get(targetClass);
                if (entry == null) {
                    entry = new ConverterEntry(targetClass);
                    entry.putCacheConverters(fromClass, converters);
                    this.m_converterMap.put(targetClass, entry);
                }
            }
        }
        if (converters.size() > 0) {
            return converters;
        }
        throw new ConverterException("No registered converter found to convert from " + ctx.getSourceClass() + " to " + ctx.getTargetType());
    }

    private void sortConverters(List<Converter<?>> converters) {
        int pos = 0;
        int i = 0;
        while (i < converters.size()) {
            Converter<?> c = converters.get(i);
            if (c instanceof IRefConverter) {
                pos = i;
                break;
            }
            ++i;
        }
        if (pos != 0) {
            Converter<?> c = converters.get(pos);
            converters.remove(pos);
            converters.add(0, c);
        }
    }

    public Class<?> findType(Class<?> abstractClass) {
        Class<?> concreteClass = this.m_typeMap.get(abstractClass);
        if (concreteClass != null) {
            return concreteClass;
        }
        return abstractClass;
    }

    private void getConverters(ConverterContext ctx, List<Converter<?>> converters, Class<?> targetClass) {
        List<Class<?>> classes = this.getSuperClassesAndInterfaces(targetClass);
        for (Class<?> clazz : classes) {
            ConverterEntry entry = this.m_converterMap.get(clazz);
            if (entry == null) continue;
            for (Converter<?> c : entry.getConverters()) {
                if (!c.canConvert(ctx)) continue;
                converters.add(c);
            }
        }
    }

    private List<Class<?>> getSuperClassesAndInterfaces(Class<?> clazz) {
        ArrayList classes = new ArrayList();
        Class<?> current = clazz;
        do {
            classes.add(current);
        } while ((current = current.getSuperclass()) != null && current != Object.class);
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> i = classArray[n2];
            if (!classes.contains(i)) {
                classes.add(i);
            }
            ++n2;
        }
        return classes;
    }

    public void registerConverter(Converter<?> converter) {
        this.registerConverter(converter, ConverterPriority.NORMAL.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConverter(Converter<?> converter, int priority) {
        Type targetType = converter.getTargetType();
        Class<?> targetClass = TypeUtil.getRawType(targetType);
        ConverterEntry entry = this.m_converterMap.get(targetClass);
        if (entry == null) {
            Map<Class<?>, ConverterEntry> map = this.m_converterMap;
            synchronized (map) {
                entry = this.m_converterMap.get(targetClass);
                if (entry == null) {
                    entry = new ConverterEntry(targetClass);
                    this.m_converterMap.put(targetClass, entry);
                }
            }
        }
        entry.addConverter(converter, priority);
    }

    public void registerType(Class<?> fromClass, Class<?> toClass) {
        Class<?> oldClass = this.m_typeMap.put(fromClass, toClass);
        if (oldClass != null && oldClass != toClass) {
            throw new IllegalArgumentException("Map to same " + fromClass + " from " + oldClass + " and " + toClass);
        }
    }

    private static class ConverterEntry {
        private Class<?> m_targetClass;
        private List<Converter<?>> m_converters;
        private List<Integer> m_priorities;
        private Map<Class<?>, List<Converter<?>>> m_cacheMap;

        public ConverterEntry(Class<?> targetClass) {
            this.m_targetClass = targetClass;
            this.m_converters = new ArrayList();
            this.m_priorities = new ArrayList<Integer>();
            this.m_cacheMap = new HashMap();
        }

        public void addConverter(Converter<?> converter, int priority) {
            if (!this.m_converters.contains(converter)) {
                int size;
                int index = size = this.m_priorities.size();
                int i = 0;
                while (i < size) {
                    if (priority > this.m_priorities.get(i)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                this.m_priorities.add(index, priority);
                this.m_converters.add(index, converter);
            } else {
                System.out.println("Converter already registered: " + converter);
            }
        }

        public List<Converter<?>> getCacheConverters(Class<?> fromClass) {
            return this.m_cacheMap.get(fromClass);
        }

        public List<Converter<?>> getConverters() {
            return this.m_converters;
        }

        public Class<?> getTargetClass() {
            return this.m_targetClass;
        }

        public void putCacheConverters(Class<?> fromClass, List<Converter<?>> converters) {
            this.m_cacheMap.put(fromClass, converters);
        }
    }
}

