/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.converter;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.unidal.webres.converter.ConverterException;
import org.unidal.webres.converter.ConverterManager;
import org.unidal.webres.converter.ConverterRuntime;

public class TypeUtil {
    public static Type getComponentType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return clazz.getComponentType();
            }
        } else {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type[] actuallTypes = parameterizedType.getActualTypeArguments();
                return actuallTypes[0];
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType genericArrayType = (GenericArrayType)type;
                return genericArrayType.getGenericComponentType();
            }
            throw new ConverterException("Unknown type: " + type);
        }
        return Object.class;
    }

    public static Class<?> getPrimitiveClass(Class<?> clazz) {
        if (clazz == String.class) {
            return clazz;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        return clazz;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class<?>)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Class<?> componentType = TypeUtil.getRawType(genericArrayType.getGenericComponentType());
            return Array.newInstance(componentType, 0).getClass();
        }
        if (!(type instanceof TypeVariable)) throw new ConverterException("Unknown type: " + type);
        Type[] bounds = ((TypeVariable)type).getBounds();
        if (bounds == null) throw new ConverterException("Unknown type variable: " + type);
        if (bounds.length != 1) throw new ConverterException("Unknown type variable: " + type);
        Type upperBound = bounds[0];
        Class<?> clazz = ConverterRuntime.INSTANCE.getManager().getRegistry().findType(TypeUtil.getRawType(upperBound));
        if (!clazz.isInterface()) return clazz;
        throw new ConverterException("Unknown type variable: " + type);
    }

    public static Class<?> getWrapClass(Class<?> clazz) {
        if (clazz == String.class) {
            return clazz;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        return clazz;
    }

    public static boolean isPrimaryClass(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        return TypeUtil.getPrimitiveClass(clazz).isPrimitive();
    }

    public static boolean isClassSupported(Class<?> fromClass, Class<?> ... classes) {
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (clazz == fromClass || clazz.isAssignableFrom(fromClass)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isUserDefinedClass(Class<?> clazz) {
        return !clazz.isPrimitive() && !clazz.getName().startsWith("java");
    }

    public static Class<?> getConcreteClass(ConverterManager manager, Type type) {
        Class<?> rawType = TypeUtil.getRawType(type);
        if (rawType.isInterface()) {
            return manager.getRegistry().findType(rawType);
        }
        return TypeUtil.getWrapClass(rawType);
    }

    public static Type getActualTypeArgument(Type type, int index) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] arguments = parameterizedType.getActualTypeArguments();
            if (index >= 0 && index < arguments.length) {
                return arguments[index];
            }
            throw new IndexOutOfBoundsException(String.valueOf(index) + " not in [0," + (arguments.length - 1) + "]");
        }
        throw new UnsupportedOperationException("not implementated yet");
    }

    public static boolean hasPublicStaticFields(Class<?> clazz) {
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (Modifier.isStatic(field.getModifiers())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Field getStaticField(Class<?> clazz, String name) throws SecurityException, NoSuchFieldException {
        Field field = clazz.getField(name);
        if (Modifier.isStatic(field.getModifiers())) {
            return field;
        }
        return null;
    }

    public static Type resolveType(ParameterizedType instanceType, Class<?> instanceClass, TypeVariable<?> parameterType) {
        String name = parameterType.getName();
        TypeVariable<Class<?>>[] typeParameters = instanceClass.getTypeParameters();
        int i = 0;
        while (i < typeParameters.length) {
            TypeVariable<Class<?>> t = typeParameters[i];
            if (t.getName().equals(name)) {
                return instanceType.getActualTypeArguments()[i];
            }
            ++i;
        }
        return parameterType;
    }
}

