/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.converter.basic;

import java.lang.reflect.Type;
import org.unidal.webres.converter.Converter;
import org.unidal.webres.converter.ConverterContext;
import org.unidal.webres.converter.ConverterException;
import org.unidal.webres.converter.TypeUtil;

public class BooleanConverter
implements Converter<Object> {
    @Override
    public boolean canConvert(ConverterContext ctx) {
        return TypeUtil.isClassSupported(ctx.getSourceClass(), Number.class, Boolean.TYPE, Boolean.class, String.class);
    }

    @Override
    public Boolean convert(ConverterContext ctx) throws ConverterException {
        Object from = ctx.getSource();
        if (from instanceof Boolean) {
            return (Boolean)from;
        }
        if (from instanceof Number) {
            if (((Number)from).intValue() > 0) {
                return true;
            }
            return false;
        }
        String text = from.toString().trim();
        if (text.length() > 0 && Character.isDigit(text.charAt(0))) {
            try {
                Double value = Double.valueOf(text);
                if (value.intValue() > 0) {
                    return true;
                }
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Boolean.valueOf(text);
    }

    @Override
    public Type getTargetType() {
        return Boolean.class;
    }
}

