/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.converter.basic;

import java.lang.reflect.Type;
import org.unidal.webres.converter.Converter;
import org.unidal.webres.converter.ConverterContext;
import org.unidal.webres.converter.ConverterException;

public class EnumConverter<T extends Enum<T>>
implements Converter<T> {
    @Override
    public boolean canConvert(ConverterContext ctx) {
        return String.class.isAssignableFrom(ctx.getSourceClass());
    }

    @Override
    public T convert(ConverterContext ctx) throws ConverterException {
        String name = (String)ctx.getSource();
        Class<?> targetClass = ctx.getTargetClass();
        return (T)Enum.valueOf(targetClass, name.trim());
    }

    @Override
    public Type getTargetType() {
        return Enum.class;
    }
}

