/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.converter.basic;

import java.lang.reflect.Type;
import org.unidal.webres.converter.Converter;
import org.unidal.webres.converter.ConverterContext;
import org.unidal.webres.converter.ConverterException;
import org.unidal.webres.converter.TypeUtil;

public class FloatConverter
implements Converter<Float> {
    @Override
    public boolean canConvert(ConverterContext ctx) {
        return TypeUtil.isClassSupported(ctx.getSourceClass(), Number.class, Boolean.TYPE, Boolean.class, String.class, Enum.class);
    }

    @Override
    public Float convert(ConverterContext ctx) throws ConverterException {
        Object from = ctx.getSource();
        if (from instanceof Number) {
            return Float.valueOf(((Number)from).floatValue());
        }
        if (from instanceof Boolean) {
            return Float.valueOf((Boolean)from != false ? Float.valueOf(1.0f).floatValue() : 0.0f);
        }
        if (from instanceof Enum) {
            return Float.valueOf(((Enum)from).ordinal());
        }
        try {
            return Float.valueOf(from.toString().trim());
        }
        catch (NumberFormatException e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public Type getTargetType() {
        return Float.class;
    }
}

