/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.converter.collection;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.List;
import org.unidal.webres.converter.Converter;
import org.unidal.webres.converter.ConverterContext;
import org.unidal.webres.converter.ConverterException;
import org.unidal.webres.converter.ConverterFatalException;

public class ArrayConverter
implements Converter<Object> {
    @Override
    public boolean canConvert(ConverterContext ctx) {
        if (!ctx.getTargetClass().isArray()) {
            return false;
        }
        Class<?> fromClass = ctx.getSourceClass();
        if (fromClass.isArray()) {
            return true;
        }
        return List.class.isAssignableFrom(fromClass);
    }

    @Override
    public Object convert(ConverterContext ctx) throws ConverterException {
        Object array;
        Class<?> fromClass = ctx.getSourceClass();
        Class<?> componentType = ctx.getTargetClass().getComponentType();
        Object from = ctx.getSource();
        if (fromClass.isArray()) {
            int length = Array.getLength(from);
            array = Array.newInstance(componentType, length);
            int i = 0;
            while (i < length) {
                Object item = Array.get(from, i);
                Object element = ctx.getManager().convert(item, componentType, true);
                Array.set(array, i, element);
                ++i;
            }
        } else if (List.class.isAssignableFrom(fromClass)) {
            List fromList = (List)from;
            int length = fromList.size();
            array = Array.newInstance(componentType, length);
            int i = 0;
            while (i < length) {
                Object item = fromList.get(i);
                Object element = ctx.getManager().convert(item, componentType, true);
                Array.set(array, i, element);
                ++i;
            }
        } else {
            throw new ConverterFatalException("Unknown type: " + fromClass, this.getClass());
        }
        return array;
    }

    @Override
    public Type getTargetType() {
        return Array.class;
    }
}

