/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.converter.node;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.unidal.webres.converter.Converter;
import org.unidal.webres.converter.ConverterContext;
import org.unidal.webres.converter.ConverterException;
import org.unidal.webres.converter.TypeUtil;
import org.unidal.webres.dom.INode;
import org.unidal.webres.dom.TagNode;

public class TagNodeConstructorConverter
implements Converter<Object> {
    @Override
    public boolean canConvert(ConverterContext ctx) {
        Class<?> targetClass = TypeUtil.getConcreteClass(ctx.getManager(), ctx.getTargetType());
        return !ctx.getTargetClass().isPrimitive() && INode.class.isAssignableFrom(ctx.getSourceClass()) && !this.hasStandardConstructor(targetClass);
    }

    private boolean hasStandardConstructor(Class<?> clazz) {
        try {
            clazz.getConstructor(new Class[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Object convert(ConverterContext ctx) throws ConverterException {
        Class<?> targetClass = TypeUtil.getConcreteClass(ctx.getManager(), ctx.getTargetType());
        TagNode node = (TagNode)ctx.getSource();
        List<INode> children = node.getChildNodes();
        int len = children.size();
        List<Constructor<?>> found = this.findConstructors(targetClass, len);
        for (Constructor<?> c : found) {
            Type[] types = c.getGenericParameterTypes();
            Object[] values = new Object[len];
            boolean isTargetParameterizedType = ctx.getTargetType() instanceof ParameterizedType;
            try {
                int i = 0;
                while (i < len) {
                    Object value;
                    INode child = children.get(i);
                    if (isTargetParameterizedType && types[i] instanceof TypeVariable) {
                        types[i] = TypeUtil.resolveType((ParameterizedType)ctx.getTargetType(), targetClass, (TypeVariable)types[i]);
                    }
                    values[i] = value = ctx.getManager().convert(child, types[i]);
                    ++i;
                }
                return c.newInstance(values);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw ConverterContext.SKIP;
    }

    private List<Constructor<?>> findConstructors(Class<?> clazz, int parameterCount) {
        Constructor<?>[] constructors = clazz.getConstructors();
        ArrayList found = new ArrayList(constructors.length);
        Constructor<?>[] constructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> c = constructorArray[n2];
            if (c.getGenericParameterTypes().length == parameterCount) {
                found.add(c);
            }
            ++n2;
        }
        return found;
    }

    @Override
    public Type getTargetType() {
        return Type.class;
    }
}

