/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.converter.node;

import java.lang.reflect.Type;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.unidal.webres.converter.ConverterContext;
import org.unidal.webres.converter.ConverterException;
import org.unidal.webres.converter.IRefConverter;
import org.unidal.webres.dom.INode;
import org.unidal.webres.dom.TagNode;

public class TagNodeRefConverter
implements IRefConverter<Object> {
    @Override
    public boolean canConvert(ConverterContext ctx) {
        Class<?> sourceClass = ctx.getSourceClass();
        return INode.class.isAssignableFrom(sourceClass);
    }

    @Override
    public Object convert(ConverterContext ctx) throws ConverterException {
        String name = this.getRefVariableName(ctx);
        if (name == null) {
            throw ConverterContext.SKIP;
        }
        return this.evaluateVariable(name, ctx);
    }

    private Object evaluateVariable(String name, ConverterContext ctx) throws ConverterException {
        PageContext pageContext = (PageContext)ConverterContext.getThreadLocal("pageContext");
        if (pageContext != null) {
            try {
                return pageContext.getVariableResolver().resolveVariable(name);
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
        throw ConverterContext.SKIP;
    }

    private String getRefVariableName(ConverterContext ctx) {
        TagNode node = (TagNode)ctx.getSource();
        Map<String, String> attributes = node.getAttributes();
        if (node.hasAttributes() && attributes.size() == 1) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String value;
                String key = entry.getKey();
                if (!this.isELAttribute(key, value = entry.getValue())) continue;
                String name = value.substring(2, value.length() - 1);
                return name;
            }
        }
        return null;
    }

    private boolean isELAttribute(String attrName, String attrValue) {
        if (attrName == null || attrValue == null) {
            return false;
        }
        return attrName.equals("value") && attrValue.startsWith("${") && attrValue.endsWith("}");
    }

    @Override
    public Type getTargetType() {
        return Type.class;
    }
}

