/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.helper;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public class Caches {
    public static MethodCache forMethod() {
        return MethodCache.INSTANCE;
    }

    public static enum MethodCache {
        INSTANCE;

        private final int LRU_CACHE_SIZE = 1024;
        private final Map<Key, Method> m_map = new LinkedHashMap<Key, Method>(1024, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Key, Method> eldest) {
                return this.size() > 1024;
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Method get(Key key) {
            Map<Key, Method> map = this.m_map;
            synchronized (map) {
                Method method = this.m_map.get(key);
                return method;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Method put(Key key, Method method) {
            Map<Key, Method> map = this.m_map;
            synchronized (map) {
                Method oldMethod = this.m_map.put(key, method);
                return oldMethod;
            }
        }

        public static interface Key {
        }
    }
}

