/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.helper;

import java.util.List;

public class Joiners {
    public static StringJoiner noDelimiter() {
        return new StringJoiner(){

            @Override
            protected void appendDelimiter(StringBuilder sb) {
            }
        };
    }

    public static StringJoiner by(final char delimiter) {
        return new StringJoiner(){

            @Override
            protected void appendDelimiter(StringBuilder sb) {
                sb.append(delimiter);
            }
        };
    }

    public static StringJoiner by(final String delimiter) {
        return new StringJoiner(){

            @Override
            protected void appendDelimiter(StringBuilder sb) {
                sb.append(delimiter);
            }
        };
    }

    public static interface IBuilder<T> {
        public String asString(T var1);
    }

    public static abstract class StringJoiner {
        private boolean m_prefixDelimiter;
        private boolean m_noEmptyItem;

        protected abstract void appendDelimiter(StringBuilder var1);

        public String join(String pre, List<String> list, String post) {
            if (list == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            if (this.m_prefixDelimiter) {
                this.appendDelimiter(sb);
                this.m_prefixDelimiter = false;
            }
            if (pre != null) {
                sb.append(pre);
                this.appendDelimiter(sb);
            }
            this.join(sb, list, null);
            if (post != null) {
                this.appendDelimiter(sb);
                sb.append(post);
            }
            return sb.toString();
        }

        public String join(List<String> list) {
            return this.join(list, null);
        }

        public <T> String join(List<T> list, IBuilder<T> builder) {
            if (list == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            this.join(sb, list, builder);
            return sb.toString();
        }

        public String join(String ... array) {
            if (array == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            if (this.m_prefixDelimiter) {
                this.appendDelimiter(sb);
            }
            String[] stringArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (!this.m_noEmptyItem || item != null && item.length() != 0) {
                    if (first) {
                        first = false;
                    } else {
                        this.appendDelimiter(sb);
                    }
                    sb.append(item);
                }
                ++n2;
            }
            return sb.toString();
        }

        public <T> void join(StringBuilder sb, List<T> list, IBuilder<T> builder) {
            boolean first = true;
            if (list != null) {
                for (T item : list) {
                    String str = builder == null ? String.valueOf(item) : builder.asString(item);
                    if (this.m_noEmptyItem && (str == null || str.length() == 0)) continue;
                    if (first) {
                        first = false;
                        if (this.m_prefixDelimiter) {
                            this.appendDelimiter(sb);
                        }
                    } else {
                        this.appendDelimiter(sb);
                    }
                    sb.append(str);
                }
            }
        }

        public StringJoiner prefixDelimiter() {
            this.m_prefixDelimiter = true;
            return this;
        }

        public StringJoiner noEmptyItem() {
            this.m_noEmptyItem = true;
            return this;
        }
    }
}

