/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.helper;

import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Node;

public class PngImageUtils {
    private static final String NONE_ALPHA = "none";
    private static final int IMAGE_INDEX_ZERO = 0;
    private static final String PNG_FORMAT = "png";
    private static final String CHANNEL_SEPARATOR = " ";
    private static final String VALUE_ATTR = "value";
    private static final String BITS_PER_SAMPLE_NODE = "BitsPerSample";
    private static final String ALPHA_NODE = "Alpha";

    public static boolean isAlphaTransparentPng(Object input) {
        if (input == null) {
            return false;
        }
        IIOMetadata metadata = PngImageUtils.retrievePngMetadata(input);
        if (metadata == null) {
            return false;
        }
        return PngImageUtils.isAlphaTransparentPng(metadata);
    }

    private static boolean isAlphaTransparentPng(IIOMetadata meta) {
        String[] names;
        String[] stringArray = names = meta.getMetadataFormatNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Node node = meta.getAsTree(name);
            Node alpha = PngImageUtils.getNodeByName(node, ALPHA_NODE);
            if (PngImageUtils.isAlphaTransprent(alpha)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static int getTransparencyChannelBitDepth(Object input) {
        IIOMetadata metadata;
        block7: {
            block6: {
                block5: {
                    try {
                        if (input != null) break block5;
                        return 0;
                    }
                    catch (Exception exception) {
                        return 0;
                    }
                }
                metadata = PngImageUtils.retrievePngMetadata(input);
                if (metadata != null) break block6;
                return 0;
            }
            boolean isAlphaTransparent = PngImageUtils.isAlphaTransparentPng(metadata);
            if (isAlphaTransparent) break block7;
            return 0;
        }
        return PngImageUtils.getTransparencyChannelBitDepth(metadata);
    }

    private static int getTransparencyChannelBitDepth(IIOMetadata meta) {
        String[] names;
        String[] stringArray = names = meta.getMetadataFormatNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Node node = meta.getAsTree(name);
            Node bitsPerSample = PngImageUtils.getNodeByName(node, BITS_PER_SAMPLE_NODE);
            int bitDepth = PngImageUtils.getTransparencyChannelBitDepth(bitsPerSample);
            if (bitDepth != 0) {
                return bitDepth;
            }
            ++n2;
        }
        return 0;
    }

    private static int getTransparencyChannelBitDepth(Node bitsPerSample) {
        if (bitsPerSample == null) {
            return 0;
        }
        Node valueAttr = bitsPerSample.getAttributes().getNamedItem(VALUE_ATTR);
        if (valueAttr == null) {
            return 0;
        }
        if (valueAttr.getNodeValue() == null) {
            return 0;
        }
        String value = valueAttr.getNodeValue();
        if (value.lastIndexOf(CHANNEL_SEPARATOR) < 0) {
            return 0;
        }
        try {
            value = value.substring(value.lastIndexOf(CHANNEL_SEPARATOR) + 1);
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static IIOMetadata retrievePngMetadata(Object input) {
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(input);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            while (readers.hasNext()) {
                ImageReader reader = readers.next();
                String formatName = reader.getFormatName();
                if (formatName == null || !formatName.equalsIgnoreCase(PNG_FORMAT)) continue;
                reader.setInput(iis);
                IIOMetadata meta = reader.getImageMetadata(0);
                return meta;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean isAlphaTransprent(Node alphaNode) {
        if (alphaNode == null) {
            return false;
        }
        Node valueAttr = alphaNode.getAttributes().getNamedItem(VALUE_ATTR);
        if (valueAttr == null) {
            return false;
        }
        if (valueAttr.getNodeValue() == null) {
            return false;
        }
        return !valueAttr.getNodeValue().equals(NONE_ALPHA);
    }

    private static Node getNodeByName(Node node, String name) {
        if (name == null || node == null) {
            return null;
        }
        if (node.getNodeName().equals(name)) {
            return node;
        }
        Node theDesiredNode = null;
        Node child = node.getFirstChild();
        while (child != null) {
            theDesiredNode = PngImageUtils.getNodeByName(child, name);
            if (theDesiredNode != null) {
                return theDesiredNode;
            }
            child = child.getNextSibling();
        }
        return null;
    }
}

