/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.json;

import java.io.UnsupportedEncodingException;
import org.unidal.webres.json.SerializationException;
import org.unidal.webres.json.serializer.ArraySerializer;
import org.unidal.webres.json.serializer.BeanSerializer;
import org.unidal.webres.json.serializer.BooleanSerializer;
import org.unidal.webres.json.serializer.DateSerializer;
import org.unidal.webres.json.serializer.DictionarySerializer;
import org.unidal.webres.json.serializer.EnumSerializer;
import org.unidal.webres.json.serializer.ISerializer;
import org.unidal.webres.json.serializer.JsonRpcSerializer;
import org.unidal.webres.json.serializer.ListSerializer;
import org.unidal.webres.json.serializer.MapSerializer;
import org.unidal.webres.json.serializer.NumberSerializer;
import org.unidal.webres.json.serializer.PrimitiveSerializer;
import org.unidal.webres.json.serializer.SetSerializer;
import org.unidal.webres.json.serializer.StringSerializer;

public class JsonSerializer {
    private static JsonSerializer s_instance;
    private JsonRpcSerializer m_rpcSerializer;

    public static JsonSerializer getInstance() {
        if (s_instance == null) {
            s_instance = new JsonSerializer();
        }
        return s_instance;
    }

    private JsonSerializer() {
        try {
            this.m_rpcSerializer = new JsonRpcSerializer();
            this.m_rpcSerializer.registerSerializer(new ArraySerializer());
            this.m_rpcSerializer.registerSerializer(new DictionarySerializer());
            this.m_rpcSerializer.registerSerializer(new MapSerializer());
            this.m_rpcSerializer.registerSerializer(new SetSerializer());
            ListSerializer listSer = new ListSerializer();
            listSer.setMarshallClassHints(false);
            this.m_rpcSerializer.registerSerializer(listSer);
            this.m_rpcSerializer.registerSerializer(new DateSerializer());
            this.m_rpcSerializer.registerSerializer(new StringSerializer());
            this.m_rpcSerializer.registerSerializer(new NumberSerializer());
            this.m_rpcSerializer.registerSerializer(new BooleanSerializer());
            this.m_rpcSerializer.registerSerializer(new PrimitiveSerializer());
            this.m_rpcSerializer.registerSerializer(new EnumSerializer());
            BeanSerializer bSer = new BeanSerializer();
            bSer.setMarshallClassHints(false);
            this.m_rpcSerializer.registerSerializer(bSer);
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
    }

    public Object deserialize(String aContent, Class<?> aClass) throws SerializationException {
        return this.m_rpcSerializer.fromJSON(aContent, aClass);
    }

    public String serialize(Object aSource) throws SerializationException, UnsupportedEncodingException {
        String str = this.m_rpcSerializer.toJSON(aSource);
        return str;
    }

    public Object deserialize(String aContent, Class<?> aClass, boolean forceClassHintsInBeanMashalling) throws SerializationException {
        return this.m_rpcSerializer.fromJSON(aContent, aClass, forceClassHintsInBeanMashalling);
    }

    public String serialize(Object aSource, boolean forceClassHintsInBeanMashalling) throws SerializationException, UnsupportedEncodingException {
        return this.m_rpcSerializer.toJSON(aSource, forceClassHintsInBeanMashalling);
    }

    public ISerializer getSerializer(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.m_rpcSerializer.getSerializer(obj.getClass(), null);
    }
}

