/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.json.serializer;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.unidal.webres.json.JsonObject;
import org.unidal.webres.json.SerializationException;
import org.unidal.webres.json.serializer.AbstractSerializer;
import org.unidal.webres.json.serializer.ObjectMatch;
import org.unidal.webres.json.serializer.SerializerState;

public class BeanSerializer
extends AbstractSerializer {
    private static Class<?>[] s_serializableClasses = new Class[0];
    private static Class<?>[] s_JSONClasses = new Class[0];
    private static volatile WeakHashMap<Class<?>, BeanData> s_beanDataCache = new WeakHashMap();

    @Override
    public Class<?>[] getSerializableClasses() {
        return s_serializableClasses;
    }

    @Override
    public Class<?>[] getJSONClasses() {
        return s_JSONClasses;
    }

    @Override
    public boolean canSerialize(Class<?> clazz, Class<?> jsonClazz) {
        return !clazz.isArray() && !clazz.isPrimitive() && !clazz.isInterface() && !clazz.isEnum() && (jsonClazz == null || jsonClazz == JsonObject.class);
    }

    private static BeanData createBeanData(Class<?> clazz) throws IntrospectionException {
        BeanData bd = new BeanData();
        PropertyDescriptor[] props = Introspector.getBeanInfo(clazz, Object.class).getPropertyDescriptors();
        bd.m_readableProps = new HashMap<String, Method>();
        bd.m_writableProps = new HashMap<String, Method>();
        int i = 0;
        while (i < props.length) {
            if (props[i].getWriteMethod() != null) {
                bd.m_writableProps.put(props[i].getName(), props[i].getWriteMethod());
            }
            if (props[i].getReadMethod() != null) {
                bd.m_readableProps.put(props[i].getName(), props[i].getReadMethod());
            }
            ++i;
        }
        return bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanData getBeanData(Class<?> clazz) throws IntrospectionException {
        BeanData bd = s_beanDataCache.get(clazz);
        if (bd != null) {
            return bd;
        }
        Class<BeanSerializer> clazz2 = BeanSerializer.class;
        synchronized (BeanSerializer.class) {
            bd = s_beanDataCache.get(clazz);
            if (bd != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return bd;
            }
            bd = BeanSerializer.createBeanData(clazz);
            WeakHashMap newCache = new WeakHashMap(s_beanDataCache.size() + 1);
            newCache.putAll(s_beanDataCache);
            newCache.put(clazz, bd);
            s_beanDataCache = newCache;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return bd;
        }
    }

    @Override
    public ObjectMatch tryUnmarshall(SerializerState state, Class<?> clazz, Object o) throws SerializationException {
        JsonObject jso = (JsonObject)o;
        BeanData bd = null;
        try {
            bd = BeanSerializer.getBeanData(clazz);
        }
        catch (IntrospectionException e) {
            throw new SerializationException(String.valueOf(clazz.getName()) + " is not a bean");
        }
        int match = 0;
        int mismatch = 0;
        for (Map.Entry<String, Method> ent : bd.m_writableProps.entrySet()) {
            String prop = ent.getKey();
            if (jso.has(prop)) {
                ++match;
                continue;
            }
            ++mismatch;
        }
        if (match == 0) {
            throw new SerializationException("bean has no matches");
        }
        ObjectMatch m = null;
        ObjectMatch tmp = null;
        Iterator<String> keyIter = jso.keys();
        while (keyIter.hasNext()) {
            String field = keyIter.next();
            Method setMethod = bd.m_writableProps.get(field);
            if (setMethod != null) {
                try {
                    Class<?>[] param = setMethod.getParameterTypes();
                    if (param.length != 1) {
                        throw new SerializationException("bean " + clazz.getName() + " method " + setMethod.getName() + " does not have one arg");
                    }
                    tmp = this.getOwner().tryUnmarshall(state, param[0], jso.get(field));
                    if (m == null) {
                        m = tmp;
                        continue;
                    }
                    m = m.max(tmp);
                    continue;
                }
                catch (SerializationException e) {
                    throw new SerializationException("bean " + clazz.getName() + " " + e.getMessage());
                }
            }
            ++mismatch;
        }
        return m.max(new ObjectMatch(mismatch));
    }

    @Override
    public Object unmarshall(SerializerState state, Class<?> clazz, Object o) throws SerializationException {
        JsonObject jso = (JsonObject)o;
        BeanData bd = null;
        try {
            bd = BeanSerializer.getBeanData(clazz);
        }
        catch (IntrospectionException e) {
            String msg = String.valueOf(clazz.getName()) + " is not a bean";
            throw new SerializationException(msg);
        }
        Object instance = null;
        try {
            instance = clazz.newInstance();
        }
        catch (Exception e) {
            String msg = "can't instantiate bean " + clazz.getName() + ": " + e.getMessage();
            throw new SerializationException(msg);
        }
        Object[] invokeArgs = new Object[1];
        Iterator<String> i = jso.keys();
        ArrayList<String> params = new ArrayList<String>();
        while (i.hasNext()) {
            Object fieldVal;
            String field = i.next();
            params.add(field);
            Method setMethod = bd.m_writableProps.get(field);
            if (setMethod != null) {
                String msg;
                try {
                    Class<?>[] param = setMethod.getParameterTypes();
                    Type[] genericParam = setMethod.getGenericParameterTypes();
                    fieldVal = this.getOwner().unmarshall(state, param[0], genericParam[0], jso.get(field));
                }
                catch (SerializationException e) {
                    msg = "bean " + clazz.getName() + " " + e.getMessage();
                    throw new SerializationException(msg);
                }
                invokeArgs[0] = fieldVal;
                try {
                    try {
                        setMethod.invoke(instance, invokeArgs);
                        continue;
                    }
                    catch (InvocationTargetException ite) {
                        throw ite.getTargetException();
                    }
                }
                catch (Throwable e) {
                    msg = "bean " + clazz.getName() + "can't invoke " + setMethod.getName() + ": " + e.getMessage();
                    throw new SerializationException(msg);
                }
            }
            Method getMethod = bd.m_readableProps.get(field);
            if (getMethod == null) continue;
            try {
                ParameterizedType returnType = (ParameterizedType)getMethod.getGenericReturnType();
                Type[] actualType = returnType.getActualTypeArguments();
                Class returnClass = (Class)returnType.getRawType();
                if (!List.class.isAssignableFrom(returnClass)) continue;
                fieldVal = this.getOwner().unmarshall(state, returnClass, actualType[0], jso.get(field));
                try {
                    List list = (List)getMethod.invoke(instance, new Object[0]);
                    List list2 = (List)fieldVal;
                    list.addAll(list2);
                }
                catch (InvocationTargetException e) {
                    throw new SerializationException(e.getMessage());
                }
                catch (IllegalArgumentException e) {
                    throw new SerializationException(e.getMessage());
                }
                catch (IllegalAccessException e) {
                    throw new SerializationException(e.getMessage());
                }
            }
            catch (SerializationException e) {
                String msg = "bean " + clazz.getName() + " " + e.getMessage();
                throw new SerializationException(msg);
            }
        }
        return instance;
    }

    @Override
    public Object marshall(SerializerState state, Object o) throws SerializationException {
        BeanSerializerState beanState;
        try {
            beanState = (BeanSerializerState)state.get(BeanSerializerState.class);
        }
        catch (Exception e) {
            throw new SerializationException("bean serializer internal error");
        }
        if (beanState.m_beanSet.get(o) == o) {
            throw new SerializationException("circular reference");
        }
        beanState.m_beanSet.put(o, o);
        Class<?> clazz = o.getClass();
        BeanData bd = null;
        try {
            bd = BeanSerializer.getBeanData(clazz);
        }
        catch (IntrospectionException e) {
            throw new SerializationException(String.valueOf(o.getClass().getName()) + " is not a bean");
        }
        JsonObject val = new JsonObject();
        if (this.isMarshallClassHints() || state.isForceClassHintsInBeanMashalling()) {
            val.put("javaClass", clazz.getName());
        }
        Iterator<Map.Entry<String, Method>> i = bd.m_readableProps.entrySet().iterator();
        Object[] args = new Object[]{};
        Object result = null;
        while (i.hasNext()) {
            Map.Entry<String, Method> ent = i.next();
            String prop = ent.getKey();
            Method getMethod = ent.getValue();
            boolean isAcc = getMethod.isAccessible();
            if (!getMethod.isAccessible() && Modifier.isPublic(getMethod.getModifiers())) {
                getMethod.setAccessible(true);
            }
            try {
                try {
                    result = getMethod.invoke(o, args);
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
            catch (Throwable e) {
                throw new SerializationException("bean " + o.getClass().getName() + " can't invoke " + getMethod.getName() + ": " + e.getMessage());
            }
            getMethod.setAccessible(isAcc);
            try {
                if (result == null && !this.getOwner().getMarshallNullAttributes()) continue;
                val.put(prop, this.getOwner().marshall(state, result));
            }
            catch (SerializationException e) {
                throw new SerializationException("bean " + o.getClass().getName() + " " + e.getMessage());
            }
        }
        beanState.m_beanSet.remove(o);
        return val;
    }

    public static class BeanData {
        public Map<String, Method> m_readableProps;
        public Map<String, Method> m_writableProps;
    }

    protected static class BeanSerializerState {
        public Map<Object, Object> m_beanSet = new HashMap<Object, Object>();

        protected BeanSerializerState() {
        }
    }
}

