/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.logging;

import org.unidal.webres.helper.Reflects;
import org.unidal.webres.logging.ConsoleLoggerFactory;
import org.unidal.webres.logging.DefaultLogger;
import org.unidal.webres.logging.ILogger;
import org.unidal.webres.logging.ILoggerFactory;

public final class LoggerFactory {
    private static ILoggerFactory m_factory = ConsoleLoggerFactory.INSTANCE;

    public static ILogger getLogger(Class<?> source) {
        return new DefaultLogger(source);
    }

    public static void setLoggerFactoryClass(String loggerClass) {
        Class<?> factoryClass = Reflects.forClass().getClass(loggerClass);
        if (factoryClass == null) {
            throw new IllegalArgumentException("Can't loading the ILoggerFactory:" + loggerClass);
        }
        Object factory = Reflects.forConstructor().createInstance(factoryClass, new Object[0]);
        if (!(factory instanceof ILoggerFactory)) {
            if (factory == null) {
                throw new IllegalArgumentException("Can't create the ILoggerFactory:" + loggerClass);
            }
            throw new IllegalArgumentException("The class is not an instance of ILoggerFactory:" + factory);
        }
        LoggerFactory.setLoggerFactory((ILoggerFactory)factory);
    }

    public static void setLoggerFactory(ILoggerFactory loggerFactory) {
        m_factory = loggerFactory;
    }

    public static ILoggerFactory getLoggerFactory() {
        return m_factory;
    }
}

