/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.tag.build;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.unidal.webres.tag.core.BaseTagLibDefinition;
import org.unidal.webres.tag.meta.TagLibMeta;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TldGenerator {
    private static String OLD_TAGLIB_URI_RESOURCE = "http://www.unidal.org/esf/resource";

    public static void main(String[] args) {
        File tldDir;
        int len = args.length;
        if (len < 2) {
            System.err.println(String.format("Usage: java %s <key> <class> [<key> <class> ...] [<outputdir>]", TldGenerator.class.getName()));
            System.exit(-1);
        }
        File file = tldDir = len % 2 == 0 ? new File(".") : new File(args[len - 1]);
        if (!tldDir.exists()) {
            tldDir.mkdirs();
        }
        if (!tldDir.isDirectory()) {
            System.err.println(String.valueOf(tldDir.toString()) + " is not a directory.");
            System.exit(-2);
        }
        if (!tldDir.canWrite()) {
            System.err.println(String.valueOf(tldDir.toString()) + " can not be written.");
            System.exit(-3);
        }
        ArrayList<Exception> tldExceptions = new ArrayList<Exception>();
        TldGenerator tldGenerator = new TldGenerator();
        int i = 0;
        while (i < len - 1) {
            tldGenerator.generateTldFile(tldDir, args[i], args[i + 1], tldExceptions, null);
            tldGenerator.generateTldFile(tldDir, String.valueOf(args[i]) + "_deprecated", args[i + 1], tldExceptions, OLD_TAGLIB_URI_RESOURCE);
            i += 2;
        }
        if (!tldExceptions.isEmpty()) {
            for (Exception e : tldExceptions) {
                e.printStackTrace();
            }
            System.err.println("Something error occured during the tld generating phase.");
            System.exit(-4);
        }
    }

    protected Document generateDocument(BaseTagLibDefinition tldef) throws DOMException, ParserConfigurationException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        this.tldefToDom(tldef, document);
        return document;
    }

    protected void generateFunction(Node node, FunctionInfo funInfo) {
        BaseTagLibDefinition.EsfFunctionInfo info;
        String description;
        Element f = this.newElement(node, "function");
        if (funInfo instanceof BaseTagLibDefinition.EsfFunctionInfo && (description = (info = (BaseTagLibDefinition.EsfFunctionInfo)funInfo).getDescription()) != null && !description.isEmpty()) {
            this.newCDATASection(this.newElement(f, "description"), description);
        }
        this.newElement(f, "name", funInfo.getName());
        this.newElement(f, "function-class", funInfo.getFunctionClass());
        this.newElement(f, "function-signature", funInfo.getFunctionSignature());
    }

    protected void generateTag(Node node, TagInfo tagInfo) {
        Element tag = this.newElement(node, "tag");
        String infoString = tagInfo.getInfoString();
        if (infoString != null && !infoString.isEmpty()) {
            this.newCDATASection(this.newElement(tag, "description"), infoString);
        }
        this.newElement(tag, "name", tagInfo.getTagName());
        this.newElement(tag, "tag-class", tagInfo.getTagClassName());
        this.newElement(tag, "body-content", tagInfo.getBodyContent());
        TagAttributeInfo[] tagAttributeInfoArray = tagInfo.getAttributes();
        int n = tagAttributeInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            BaseTagLibDefinition.EsfTagAttributeInfo info;
            String description;
            TagAttributeInfo tagAttr = tagAttributeInfoArray[n2];
            Element attr = this.newElement(tag, "attribute");
            if (tagAttr instanceof BaseTagLibDefinition.EsfTagAttributeInfo && (description = (info = (BaseTagLibDefinition.EsfTagAttributeInfo)tagAttr).getDescription()) != null && !description.isEmpty()) {
                this.newCDATASection(this.newElement(attr, "description"), description);
            }
            this.newElement(attr, "name", tagAttr.getName());
            this.newElement(attr, "required", tagAttr.isRequired());
            this.newElement(attr, "rtexprvalue", tagAttr.canBeRequestTime());
            this.newElement(attr, "type", tagAttr.getTypeName());
            ++n2;
        }
        this.newElement(tag, "dynamic-attributes", tagInfo.hasDynamicAttributes());
    }

    protected void generateTagFile(Node node, TagFileInfo info) {
        Element tag = this.newElement(node, "tag-file");
        this.newElement(tag, "name", info.getName());
        this.newElement(tag, "path", info.getPath());
    }

    public void generateTldFile(File tldDir, String fileName, String className, List<Exception> tldExceptions, String newUri) {
        File tldFile = new File(tldDir, String.valueOf(fileName) + ".tld");
        try {
            BaseTagLibDefinition tldef = this.getInstanceOfDefinition(Thread.currentThread().getContextClassLoader().loadClass(className));
            if (newUri != null) {
                tldef.setUri(newUri);
            }
            Document document = this.generateDocument(tldef);
            this.transformDom(new DOMSource(document), new StreamResult(tldFile));
            if (tldExceptions.isEmpty()) {
                System.out.println("TLD file " + tldFile.getCanonicalPath() + " generated");
            } else {
                for (Exception e : tldExceptions) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            tldExceptions.add(e);
        }
    }

    protected BaseTagLibDefinition getInstanceOfDefinition(Class<? extends BaseTagLibDefinition> clz) throws Exception {
        String tagLibUri = null;
        Class[] CONSTRUCTOR = new Class[]{String.class, String.class, String.class, String.class, String.class};
        TagLibMeta tagMeta = clz.getAnnotation(TagLibMeta.class);
        if (tagMeta == null) {
            throw new Exception(String.valueOf(clz.getName()) + " is missing tag meta annotation.");
        }
        tagLibUri = tagMeta != null && tagMeta.uri().length() > 0 ? tagMeta.uri() : clz.getName().replace('.', '/');
        try {
            Constructor<? extends BaseTagLibDefinition> constructor = clz.getDeclaredConstructor(CONSTRUCTOR);
            Object[] params = new Object[]{tagLibUri, tagMeta.shortName(), tagMeta.description(), tagMeta.version(), tagMeta.jspVersion()};
            BaseTagLibDefinition lib = constructor.newInstance(params);
            return lib;
        }
        catch (Exception e) {
            throw new Exception("Unable to construct tag lib definition: " + tagLibUri, e);
        }
    }

    protected final CDATASection newCDATASection(Node node, String name) {
        CDATASection cds = node.getOwnerDocument() == null ? ((Document)node).createCDATASection(name) : node.getOwnerDocument().createCDATASection(name);
        return (CDATASection)node.appendChild(cds);
    }

    protected final Element newElement(Node node, String name) {
        return this.newElement(node, name, null);
    }

    protected final Element newElement(Node node, String name, Object value) {
        Element e;
        Element element = e = node.getOwnerDocument() == null ? ((Document)node).createElement(name) : node.getOwnerDocument().createElement(name);
        if (value != null) {
            e.setTextContent(value.toString());
        }
        return (Element)node.appendChild(e);
    }

    protected void tldefToDom(BaseTagLibDefinition tldef, Document document) throws DOMException, ParserConfigurationException {
        Element taglib = this.newElement(document, "taglib");
        taglib.setAttribute("xmlns", "http://java.sun.com/xml/ns/j2ee");
        taglib.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        taglib.setAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-jsptaglibrary_2_0.xsd");
        taglib.setAttribute("version", tldef.getJspVersion());
        this.newElement(taglib, "description", tldef.getInfo());
        this.newElement(taglib, "tlib-version", "1.0");
        this.newElement(taglib, "short-name", tldef.getShortName());
        this.newElement(taglib, "uri", tldef.getUri());
        ArrayList<TagInfo> tags = new ArrayList<TagInfo>(tldef.getTags().values());
        ArrayList<TagFileInfo> tagFiles = new ArrayList<TagFileInfo>(tldef.getTagFiles().values());
        ArrayList<FunctionInfo> functions = new ArrayList<FunctionInfo>(tldef.getFunctions().values());
        Collections.sort(tags, new Comparator<TagInfo>(){

            @Override
            public int compare(TagInfo o1, TagInfo o2) {
                return o1.getTagName().compareTo(o2.getTagName());
            }
        });
        Collections.sort(tags, new Comparator<TagInfo>(){

            @Override
            public int compare(TagInfo o1, TagInfo o2) {
                return o1.getTagName().compareTo(o2.getTagName());
            }
        });
        Collections.sort(tagFiles, new Comparator<TagFileInfo>(){

            @Override
            public int compare(TagFileInfo o1, TagFileInfo o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Collections.sort(functions, new Comparator<FunctionInfo>(){

            @Override
            public int compare(FunctionInfo o1, FunctionInfo o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (TagInfo tagInfo : tags) {
            this.generateTag(taglib, tagInfo);
        }
        for (TagFileInfo tagFileInfo : tagFiles) {
            this.generateTagFile(taglib, tagFileInfo);
        }
        for (FunctionInfo functionInfo : functions) {
            this.generateFunction(taglib, functionInfo);
        }
    }

    protected void transformDom(Source source, Result result) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(source, result);
    }
}

