/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.tag.core;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.DynamicAttributes;
import org.unidal.webres.converter.ConverterContext;
import org.unidal.webres.dom.INode;
import org.unidal.webres.dom.ITagNode;
import org.unidal.webres.dom.NodeType;
import org.unidal.webres.tag.core.BaseBodyTagHandler;
import org.unidal.webres.tag.core.TagModelInjector;
import org.unidal.webres.tag.core.TagXmlParser;
import org.unidal.webres.tag.meta.TagElementMeta;
import org.unidal.webres.tag.meta.TagMeta;
import org.xml.sax.SAXException;

public abstract class BaseJspTagHandler<T>
extends BaseBodyTagHandler
implements DynamicAttributes {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> m_dynamicAttributes = new HashMap<String, Object>();
    private StringBuilder m_buffer = new StringBuilder(1024);
    private ITagNode m_dynamicElements;

    protected abstract T buildComponent();

    @Override
    public int doEndTag() throws JspException {
        int doEndTag = super.doEndTag();
        this.m_dynamicAttributes.clear();
        this.m_buffer.setLength(0);
        return doEndTag;
    }

    protected void flushBuffer() {
        if (this.m_buffer.length() > 0) {
            try {
                this.write(this.m_buffer.toString());
            }
            catch (IOException e) {
                this.onError("Error when flushing buffer!", e);
            }
            this.m_buffer.setLength(0);
        }
    }

    protected StringBuilder getBuffer() {
        return this.m_buffer;
    }

    protected Map<String, Object> getDynamicAttributes() {
        return this.m_dynamicAttributes;
    }

    protected Map<String, ITagNode> getDynamicElements() {
        if (this.m_dynamicElements != null && this.m_dynamicElements.hasChildNodes()) {
            LinkedHashMap<String, ITagNode> elements = new LinkedHashMap<String, ITagNode>();
            for (INode node : this.m_dynamicElements.getChildNodes()) {
                if (node.getNodeType() == NodeType.TEXT) continue;
                ITagNode tagNode = (ITagNode)node;
                elements.put(tagNode.getNodeName(), tagNode);
            }
            return elements;
        }
        return Collections.emptyMap();
    }

    @Override
    protected void handleBody() throws JspTagException {
        TagMeta tagMeta = ((Object)((Object)this)).getClass().getAnnotation(TagMeta.class);
        TagModelInjector injector = TagModelInjector.getInstance();
        if (tagMeta.parseBody() && this.bodyContent != null) {
            ITagNode root = null;
            try {
                root = this.parseBody();
            }
            catch (Exception e) {
                this.onError("Error when parsing body content!", e);
            }
            try {
                this.injectElements(injector, root);
            }
            catch (Exception e) {
                this.onError("Error when injecting elements!", e);
            }
        }
        T component = null;
        try {
            component = this.buildComponent();
        }
        catch (Exception e) {
            this.onError("Error when building component!", e);
        }
        if (component != null) {
            try {
                this.renderComponent(component);
            }
            catch (Exception e) {
                this.onError("Error when rendering component!", e);
            }
        }
        this.flushBuffer();
    }

    protected void injectElements(TagModelInjector injector, ITagNode root) {
        injector.inject((Object)this, root);
    }

    protected void onError(String message, Exception e) {
        throw new RuntimeException(message, e);
    }

    protected void out(Object value) {
        this.m_buffer.append(value);
    }

    protected ITagNode parseBody() throws SAXException, IOException {
        return new TagXmlParser().parse(this.bodyContent.getString());
    }

    protected abstract void renderComponent(T var1);

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        this.m_dynamicAttributes.put(localName, value);
    }

    @TagElementMeta(customized=true)
    public void setDynamicElements(ITagNode dynamicElements) {
        this.m_dynamicElements = dynamicElements;
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        ConverterContext.setThreadLocal("pageContext", pageContext);
    }
}

