/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.tag.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.unidal.webres.tag.core.ITag;
import org.unidal.webres.tag.core.ITagAdvice;
import org.unidal.webres.tag.core.ITagEnv;
import org.unidal.webres.tag.core.ITagModel;
import org.unidal.webres.tag.core.TagAdviceTarget;

public abstract class BaseTagEnv
implements ITagEnv {
    protected StringBuilder m_err;
    protected StringBuilder m_out;
    private ITagEnv.TagOutputType m_outputType = ITagEnv.TagOutputType.html;
    private Map<String, Object> m_properties;
    private ITagAdvice m_tagAdvice;

    public ITagAdvice getTagAdvice() {
        return this.m_tagAdvice;
    }

    public void setTagAdvice(ITagAdvice tagAdvice) {
        this.m_tagAdvice = tagAdvice;
    }

    @Override
    public BaseTagEnv err(Object value) {
        if (this.m_err == null) {
            this.m_err = new StringBuilder(1024);
        }
        this.m_err.append(value);
        return this;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public String getError() {
        if (this.m_err == null) {
            return "";
        }
        String value = this.m_err.toString();
        this.m_err.setLength(0);
        return value;
    }

    @Override
    public String getOutput() {
        if (this.m_out == null) {
            return "";
        }
        String value = this.m_out.toString();
        this.m_out.setLength(0);
        return value;
    }

    @Override
    public ITagEnv.TagOutputType getOutputType() {
        return this.m_outputType;
    }

    @Override
    public Object getProperty(String name) {
        if (this.m_properties != null) {
            return this.m_properties.get(name);
        }
        return null;
    }

    @Override
    public void onError(String message, Throwable cause) {
        throw new RuntimeException(message, cause);
    }

    @Override
    public BaseTagEnv out(Object value) {
        if (value != null) {
            if (this.m_out == null) {
                this.m_out = new StringBuilder(1024);
            }
            this.m_out.append(value);
        }
        return this;
    }

    @Override
    public void setOutputType(ITagEnv.TagOutputType type) {
        if (type == null) {
            throw new IllegalArgumentException("TagOutputType can't be null.");
        }
        this.m_outputType = type;
    }

    @Override
    public void setProperty(String name, Object value) {
        if (this.m_properties == null) {
            this.m_properties = new HashMap<String, Object>();
        }
        this.m_properties.put(name, value);
    }

    @Override
    public <T, M extends ITagModel> void onBegin(ITag<T, M> tag, TagAdviceTarget target) {
        if (this.m_tagAdvice != null) {
            this.m_tagAdvice.onBegin(tag, target);
        }
    }

    @Override
    public <T, M extends ITagModel> void onEnd(ITag<T, M> tag, TagAdviceTarget target) {
        if (this.m_tagAdvice != null) {
            this.m_tagAdvice.onEnd(tag, target);
        }
    }

    @Override
    public <T, M extends ITagModel> boolean onError(ITag<T, M> tag, TagAdviceTarget target, Throwable cause) {
        if (this.m_tagAdvice != null) {
            return this.m_tagAdvice.onError(tag, target, cause);
        }
        return true;
    }
}

