/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.tag.core;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.DynamicAttributes;
import org.unidal.webres.helper.Markers;
import org.unidal.webres.tag.core.BaseBodyTagHandler;
import org.unidal.webres.tag.core.IDeferRenderable;
import org.unidal.webres.tag.core.ITag;
import org.unidal.webres.tag.core.ITagEnv;
import org.unidal.webres.tag.core.ITagModel;
import org.unidal.webres.tag.core.JspTagEnv;
import org.unidal.webres.tag.core.TagAdviceTarget;

public abstract class BaseTagHandler<C, M extends ITagModel, T extends ITag<C, M>>
extends BaseBodyTagHandler
implements DynamicAttributes {
    private static final long serialVersionUID = 1L;
    private T m_tag;

    protected abstract T createTag();

    protected JspTagEnv createTagEnv() {
        return new JspTagEnv();
    }

    protected void initTagEnv(JspTagEnv env, T tag) {
        env.setPageContext(this.pageContext);
    }

    @Override
    public int doEndTag() throws JspException {
        int result;
        block6: {
            result = super.doEndTag();
            ITagEnv env = this.m_tag.getEnv();
            env.onBegin(this.m_tag, TagAdviceTarget.END);
            try {
                try {
                    this.m_tag.end();
                    this.m_tag.setState(ITag.State.ENDED);
                }
                catch (RuntimeException cause) {
                    if (env.onError(this.m_tag, TagAdviceTarget.END, cause)) {
                        throw cause;
                    }
                    env.onEnd(this.m_tag, TagAdviceTarget.END);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                env.onEnd(this.m_tag, TagAdviceTarget.END);
                throw throwable;
            }
            env.onEnd(this.m_tag, TagAdviceTarget.END);
        }
        this.m_tag = null;
        return result;
    }

    public int doStartTag() throws JspException {
        block6: {
            JspTagEnv env = this.createTagEnv();
            this.ensureTag();
            this.initTagEnv(env, this.m_tag);
            this.m_tag.setEnv(env);
            env.onBegin(this.m_tag, TagAdviceTarget.START);
            try {
                try {
                    this.m_tag.start();
                    this.m_tag.setState(ITag.State.STARTED);
                }
                catch (RuntimeException cause) {
                    if (env.onError(this.m_tag, TagAdviceTarget.START, cause)) {
                        throw cause;
                    }
                    env.onEnd(this.m_tag, TagAdviceTarget.START);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                env.onEnd(this.m_tag, TagAdviceTarget.START);
                throw throwable;
            }
            env.onEnd(this.m_tag, TagAdviceTarget.START);
        }
        return super.doStartTag();
    }

    private void ensureTag() {
        if (this.m_tag == null) {
            this.m_tag = this.createTag();
        }
    }

    protected void flushBuffer() {
        ITagEnv env = this.m_tag.getEnv();
        try {
            this.write(env.getError());
            this.write(env.getOutput());
        }
        catch (IOException e) {
            env.onError("Error when flushing buffer!", e);
        }
    }

    protected M getModel() {
        this.ensureTag();
        return this.m_tag.getModel();
    }

    protected T getTag() {
        return this.m_tag;
    }

    @Override
    protected void handleBody() throws JspTagException {
        String content;
        if (this.bodyContent != null && (content = this.bodyContent.getString()) != null) {
            this.m_tag.getModel().setBodyContent(content);
        }
        ITagEnv env = this.m_tag.getEnv();
        env.onBegin(this.m_tag, TagAdviceTarget.BUILD);
        C component = null;
        try {
            try {
                component = (C)this.m_tag.build();
                this.m_tag.setState(ITag.State.BUILT);
            }
            catch (RuntimeException cause) {
                env.onError(this.m_tag, TagAdviceTarget.BUILD, cause);
                throw cause;
            }
        }
        finally {
            env.onEnd(this.m_tag, TagAdviceTarget.BUILD);
        }
        if (this.m_tag instanceof IDeferRenderable) {
            IDeferRenderable renderable = (IDeferRenderable)this.m_tag;
            boolean flag = renderable.prepareForDefer(component);
            if (flag) {
                String deferType = renderable.getDeferType();
                String deferId = renderable.getDeferId();
                this.m_tag.getEnv().out(Markers.forDefer().build(deferType, deferId));
            } else {
                this.renderComponent(component);
            }
        } else {
            this.renderComponent(component);
        }
        this.flushBuffer();
    }

    protected void renderComponent(C component) {
        if (component != null) {
            ITagEnv env = this.m_tag.getEnv();
            env.onBegin(this.m_tag, TagAdviceTarget.RENDER);
            try {
                try {
                    this.m_tag.render(component);
                    this.m_tag.setState(ITag.State.RENDERED);
                }
                catch (RuntimeException cause) {
                    if (env.onError(this.m_tag, TagAdviceTarget.RENDER, cause)) {
                        throw cause;
                    }
                    env.onEnd(this.m_tag, TagAdviceTarget.RENDER);
                }
            }
            finally {
                env.onEnd(this.m_tag, TagAdviceTarget.RENDER);
            }
        }
    }

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        this.ensureTag();
        this.m_tag.getModel().setDynamicAttribute(localName, value);
    }
}

