/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.tx;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.EventValues;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.crypto.Credentials;
import org.web3j.ens.EnsResolver;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.response.EthGetCode;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.exceptions.TransactionException;
import org.web3j.tx.ManagedTransaction;
import org.web3j.tx.RawTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.exceptions.ContractCallException;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.StaticGasProvider;
import org.web3j.utils.Numeric;
import org.web3j.utils.RevertReasonExtractor;

public abstract class Contract
extends ManagedTransaction {
    public static final BigInteger GAS_LIMIT = BigInteger.valueOf(4300000L);
    public static final String BIN_NOT_PROVIDED = "Bin file was not provided";
    public static final String FUNC_DEPLOY = "deploy";
    protected final String contractBinary;
    protected String contractAddress;
    protected ContractGasProvider gasProvider;
    protected TransactionReceipt transactionReceipt;
    protected Map<String, String> deployedAddresses;
    protected DefaultBlockParameter defaultBlockParameter = DefaultBlockParameterName.LATEST;

    protected Contract(String contractBinary, String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider gasProvider) {
        this(new EnsResolver(web3j), contractBinary, contractAddress, web3j, transactionManager, gasProvider);
    }

    protected Contract(EnsResolver ensResolver, String contractBinary, String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider gasProvider) {
        super(ensResolver, web3j, transactionManager);
        this.contractAddress = this.resolveContractAddress(contractAddress);
        this.contractBinary = contractBinary;
        this.gasProvider = gasProvider;
    }

    protected Contract(String contractBinary, String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider gasProvider) {
        this(new EnsResolver(web3j), contractBinary, contractAddress, web3j, new RawTransactionManager(web3j, credentials), gasProvider);
    }

    @Deprecated
    protected Contract(String contractBinary, String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        this(new EnsResolver(web3j), contractBinary, contractAddress, web3j, transactionManager, new StaticGasProvider(gasPrice, gasLimit));
    }

    @Deprecated
    protected Contract(String contractBinary, String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        this(contractBinary, contractAddress, web3j, new RawTransactionManager(web3j, credentials), gasPrice, gasLimit);
    }

    @Deprecated
    protected Contract(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        this("", contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    @Deprecated
    protected Contract(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        this("", contractAddress, web3j, new RawTransactionManager(web3j, credentials), gasPrice, gasLimit);
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setTransactionReceipt(TransactionReceipt transactionReceipt) {
        this.transactionReceipt = transactionReceipt;
    }

    public String getContractBinary() {
        return this.contractBinary;
    }

    public void setGasProvider(ContractGasProvider gasProvider) {
        this.gasProvider = gasProvider;
    }

    public void setGasPrice(BigInteger newPrice) {
        this.gasProvider = new StaticGasProvider(newPrice, this.gasProvider.getGasLimit());
    }

    public BigInteger getGasPrice() {
        return this.gasProvider.getGasPrice();
    }

    public boolean isValid() throws IOException {
        if (this.contractBinary.equals(BIN_NOT_PROVIDED)) {
            throw new UnsupportedOperationException("Contract binary not present in contract wrapper, please generate your wrapper using -abiFile=<file>");
        }
        if (this.contractAddress.equals("")) {
            throw new UnsupportedOperationException("Contract binary not present, you will need to regenerate your smart contract wrapper with web3j v2.2.0+");
        }
        EthGetCode ethGetCode = this.transactionManager.getCode(this.contractAddress, DefaultBlockParameterName.LATEST);
        if (ethGetCode.hasError()) {
            return false;
        }
        String code = Numeric.cleanHexPrefix((String)ethGetCode.getCode());
        int metadataIndex = code.indexOf("a165627a7a72305820");
        if (metadataIndex != -1) {
            code = code.substring(0, metadataIndex);
        }
        return !code.isEmpty() && this.contractBinary.contains(code);
    }

    public Optional<TransactionReceipt> getTransactionReceipt() {
        return Optional.ofNullable(this.transactionReceipt);
    }

    public void setDefaultBlockParameter(DefaultBlockParameter defaultBlockParameter) {
        this.defaultBlockParameter = defaultBlockParameter;
    }

    private List<Type> executeCall(Function function) throws IOException {
        String encodedFunction = FunctionEncoder.encode((Function)function);
        String value = this.call(this.contractAddress, encodedFunction, this.defaultBlockParameter);
        return FunctionReturnDecoder.decode((String)value, (List)function.getOutputParameters());
    }

    protected <T extends Type> T executeCallSingleValueReturn(Function function) throws IOException {
        List<Type> values = this.executeCall(function);
        if (!values.isEmpty()) {
            return (T)values.get(0);
        }
        return null;
    }

    protected <T extends Type, R> R executeCallSingleValueReturn(Function function, Class<R> returnType) throws IOException {
        T result = this.executeCallSingleValueReturn(function);
        if (result == null) {
            throw new ContractCallException("Empty value (0x) returned from contract");
        }
        Object value = result.getValue();
        if (returnType.isAssignableFrom(result.getClass())) {
            return (R)result;
        }
        if (returnType.isAssignableFrom(value.getClass())) {
            return (R)value;
        }
        if (result.getClass().equals(Address.class) && returnType.equals(String.class)) {
            return (R)result.toString();
        }
        throw new ContractCallException("Unable to convert response: " + value + " to expected type: " + returnType.getSimpleName());
    }

    protected List<Type> executeCallMultipleValueReturn(Function function) throws IOException {
        return this.executeCall(function);
    }

    protected TransactionReceipt executeTransaction(Function function) throws IOException, TransactionException {
        return this.executeTransaction(function, BigInteger.ZERO);
    }

    private TransactionReceipt executeTransaction(Function function, BigInteger weiValue) throws IOException, TransactionException {
        return this.executeTransaction(FunctionEncoder.encode((Function)function), weiValue, function.getName());
    }

    TransactionReceipt executeTransaction(String data, BigInteger weiValue, String funcName) throws TransactionException, IOException {
        return this.executeTransaction(data, weiValue, funcName, false);
    }

    TransactionReceipt executeTransaction(String data, BigInteger weiValue, String funcName, boolean constructor) throws TransactionException, IOException {
        TransactionReceipt receipt = this.send(this.contractAddress, data, weiValue, this.gasProvider.getGasPrice(funcName), this.gasProvider.getGasLimit(funcName), constructor);
        if (!receipt.isStatusOK()) {
            throw new TransactionException(String.format("Transaction %s has failed with status: %s. Gas used: %s. Revert reason: '%s'.", receipt.getTransactionHash(), receipt.getStatus(), receipt.getGasUsedRaw() != null ? receipt.getGasUsed().toString() : "unknown", RevertReasonExtractor.extractRevertReason(receipt, data, this.web3j, true)), receipt);
        }
        return receipt;
    }

    protected <T extends Type> RemoteFunctionCall<T> executeRemoteCallSingleValueReturn(Function function) {
        return new RemoteFunctionCall<Type>(function, () -> this.executeCallSingleValueReturn(function));
    }

    protected <T> RemoteFunctionCall<T> executeRemoteCallSingleValueReturn(Function function, Class<T> returnType) {
        return new RemoteFunctionCall<Object>(function, () -> this.executeCallSingleValueReturn(function, returnType));
    }

    protected RemoteFunctionCall<List<Type>> executeRemoteCallMultipleValueReturn(Function function) {
        return new RemoteFunctionCall<List<Type>>(function, () -> this.executeCallMultipleValueReturn(function));
    }

    protected RemoteFunctionCall<TransactionReceipt> executeRemoteCallTransaction(Function function) {
        return new RemoteFunctionCall<TransactionReceipt>(function, () -> this.executeTransaction(function));
    }

    protected RemoteFunctionCall<TransactionReceipt> executeRemoteCallTransaction(Function function, BigInteger weiValue) {
        return new RemoteFunctionCall<TransactionReceipt>(function, () -> this.executeTransaction(function, weiValue));
    }

    private static <T extends Contract> T create(T contract, String binary, String encodedConstructor, BigInteger value) throws IOException, TransactionException {
        TransactionReceipt transactionReceipt = contract.executeTransaction(binary + encodedConstructor, value, FUNC_DEPLOY, true);
        String contractAddress = transactionReceipt.getContractAddress();
        if (contractAddress == null) {
            throw new RuntimeException("Empty contract address returned");
        }
        contract.setContractAddress(contractAddress);
        contract.setTransactionReceipt(transactionReceipt);
        return contract;
    }

    protected static <T extends Contract> T deploy(Class<T> type, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String binary, String encodedConstructor, BigInteger value) throws RuntimeException, TransactionException {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(String.class, Web3j.class, Credentials.class, ContractGasProvider.class);
            constructor.setAccessible(true);
            Contract contract = (Contract)constructor.newInstance(null, web3j, credentials, contractGasProvider);
            return (T)Contract.create(contract, binary, encodedConstructor, value);
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T extends Contract> T deploy(Class<T> type, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String binary, String encodedConstructor, BigInteger value) throws RuntimeException, TransactionException {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(String.class, Web3j.class, TransactionManager.class, ContractGasProvider.class);
            constructor.setAccessible(true);
            Contract contract = (Contract)constructor.newInstance(null, web3j, transactionManager, contractGasProvider);
            return (T)Contract.create(contract, binary, encodedConstructor, value);
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    protected static <T extends Contract> T deploy(Class<T> type, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor, BigInteger value) throws RuntimeException, TransactionException {
        return Contract.deploy(type, web3j, credentials, (ContractGasProvider)new StaticGasProvider(gasPrice, gasLimit), binary, encodedConstructor, value);
    }

    @Deprecated
    protected static <T extends Contract> T deploy(Class<T> type, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor, BigInteger value) throws RuntimeException, TransactionException {
        return Contract.deploy(type, web3j, transactionManager, (ContractGasProvider)new StaticGasProvider(gasPrice, gasLimit), binary, encodedConstructor, value);
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor, BigInteger value) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, web3j, credentials, gasPrice, gasLimit, binary, encodedConstructor, value));
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor) {
        return Contract.deployRemoteCall(type, web3j, credentials, gasPrice, gasLimit, binary, encodedConstructor, BigInteger.ZERO);
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String binary, String encodedConstructor, BigInteger value) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, web3j, credentials, contractGasProvider, binary, encodedConstructor, value));
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String binary, String encodedConstructor) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, web3j, credentials, contractGasProvider, binary, encodedConstructor, BigInteger.ZERO));
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor, BigInteger value) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, web3j, transactionManager, gasPrice, gasLimit, binary, encodedConstructor, value));
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor) {
        return Contract.deployRemoteCall(type, web3j, transactionManager, gasPrice, gasLimit, binary, encodedConstructor, BigInteger.ZERO);
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String binary, String encodedConstructor, BigInteger value) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, web3j, transactionManager, contractGasProvider, binary, encodedConstructor, value));
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String binary, String encodedConstructor) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, web3j, transactionManager, contractGasProvider, binary, encodedConstructor, BigInteger.ZERO));
    }

    public static EventValues staticExtractEventParameters(Event event, Log log) {
        List<String> topics = log.getTopics();
        String encodedEventSignature = EventEncoder.encode((Event)event);
        if (topics == null || topics.size() == 0 || !topics.get(0).equals(encodedEventSignature)) {
            return null;
        }
        ArrayList<Type> indexedValues = new ArrayList<Type>();
        List nonIndexedValues = FunctionReturnDecoder.decode((String)log.getData(), (List)event.getNonIndexedParameters());
        List indexedParameters = event.getIndexedParameters();
        for (int i = 0; i < indexedParameters.size(); ++i) {
            Type value = FunctionReturnDecoder.decodeIndexedValue((String)topics.get(i + 1), (TypeReference)((TypeReference)indexedParameters.get(i)));
            indexedValues.add(value);
        }
        return new EventValues(indexedValues, nonIndexedValues);
    }

    protected String resolveContractAddress(String contractAddress) {
        return this.ensResolver.resolve(contractAddress);
    }

    protected EventValues extractEventParameters(Event event, Log log) {
        return Contract.staticExtractEventParameters(event, log);
    }

    protected List<EventValues> extractEventParameters(Event event, TransactionReceipt transactionReceipt) {
        return transactionReceipt.getLogs().stream().map(log -> this.extractEventParameters(event, (Log)log)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected EventValuesWithLog extractEventParametersWithLog(Event event, Log log) {
        return Contract.staticExtractEventParametersWithLog(event, log);
    }

    protected static EventValuesWithLog staticExtractEventParametersWithLog(Event event, Log log) {
        EventValues eventValues = Contract.staticExtractEventParameters(event, log);
        return eventValues == null ? null : new EventValuesWithLog(eventValues, log);
    }

    protected List<EventValuesWithLog> extractEventParametersWithLog(Event event, TransactionReceipt transactionReceipt) {
        return transactionReceipt.getLogs().stream().map(log -> this.extractEventParametersWithLog(event, (Log)log)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected String getStaticDeployedAddress(String networkId) {
        return null;
    }

    public final void setDeployedAddress(String networkId, String address) {
        if (this.deployedAddresses == null) {
            this.deployedAddresses = new HashMap<String, String>();
        }
        this.deployedAddresses.put(networkId, address);
    }

    public final String getDeployedAddress(String networkId) {
        String addr = null;
        if (this.deployedAddresses != null) {
            addr = this.deployedAddresses.get(networkId);
        }
        return addr == null ? this.getStaticDeployedAddress(networkId) : addr;
    }

    protected static <S extends Type, T> List<T> convertToNative(List<S> arr) {
        ArrayList<Object> out = new ArrayList<Object>();
        for (Type s : arr) {
            out.add(s.getValue());
        }
        return out;
    }

    public static class EventValuesWithLog {
        private final EventValues eventValues;
        private final Log log;

        private EventValuesWithLog(EventValues eventValues, Log log) {
            this.eventValues = eventValues;
            this.log = log;
        }

        public List<Type> getIndexedValues() {
            return this.eventValues.getIndexedValues();
        }

        public List<Type> getNonIndexedValues() {
            return this.eventValues.getNonIndexedValues();
        }

        public Log getLog() {
            return this.log;
        }
    }
}

