/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.tx.response;

import java.io.IOException;
import java.util.Optional;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.exceptions.TransactionException;
import org.web3j.tx.response.TransactionReceiptProcessor;

public class PollingTransactionReceiptProcessor
extends TransactionReceiptProcessor {
    protected final long sleepDuration;
    protected final int attempts;

    public PollingTransactionReceiptProcessor(Web3j web3j, long sleepDuration, int attempts) {
        super(web3j);
        this.sleepDuration = sleepDuration;
        this.attempts = attempts;
    }

    @Override
    public TransactionReceipt waitForTransactionReceipt(String transactionHash) throws IOException, TransactionException {
        return this.getTransactionReceipt(transactionHash, this.sleepDuration, this.attempts);
    }

    private TransactionReceipt getTransactionReceipt(String transactionHash, long sleepDuration, int attempts) throws IOException, TransactionException {
        Optional<? extends TransactionReceipt> receiptOptional = this.sendTransactionReceiptRequest(transactionHash);
        for (int i = 0; i < attempts; ++i) {
            if (!receiptOptional.isPresent()) {
                try {
                    Thread.sleep(sleepDuration);
                }
                catch (InterruptedException e) {
                    throw new TransactionException(e);
                }
            } else {
                return receiptOptional.get();
            }
            receiptOptional = this.sendTransactionReceiptRequest(transactionHash);
        }
        throw new TransactionException("Transaction receipt was not generated after " + sleepDuration * (long)attempts / 1000L + " seconds for transaction: " + transactionHash, transactionHash);
    }
}

