/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.properties;

import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.util.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ResourceTypeProperty
extends BaseProperty {
    private boolean initialized = false;
    private boolean isCollection = false;
    private boolean isPrincipal = false;
    public static final String TAG_NAME = "resourcetype";
    public static final String TAG_COLLECTION = "collection";
    public static final String TAG_PRINCIPAL = "principal";

    public ResourceTypeProperty(ResponseEntity response, Element element) {
        super(response, element);
    }

    public boolean isCollection() {
        this.init();
        return this.isCollection;
    }

    public boolean isPrincipal() {
        this.init();
        return this.isPrincipal;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        NodeList tmp = this.element.getChildNodes();
        for (int i = 0; tmp != null && i < tmp.getLength(); ++i) {
            try {
                Element child = (Element)tmp.item(i);
                if (TAG_COLLECTION.equals(DOMUtils.getElementLocalName(child)) && "DAV:".equals(DOMUtils.getElementNamespaceURI(child))) {
                    this.isCollection = true;
                }
                if (!TAG_PRINCIPAL.equals(DOMUtils.getElementLocalName(child)) || !"DAV:".equals(DOMUtils.getElementNamespaceURI(child))) continue;
                this.isPrincipal = true;
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public String getPropertyAsString() {
        this.init();
        return this.isCollection ? "COLLECTION" : "";
    }
}

