/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MetricStatistic {
    AVERAGE("Average"),
    MINIMUM("Minimum"),
    MAXIMUM("Maximum"),
    SAMPLE_COUNT("SampleCount"),
    SUM("Sum"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetricStatistic> VALUE_MAP;
    private final String value;

    private MetricStatistic(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricStatistic fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricStatistic> knownValues() {
        EnumSet<MetricStatistic> knownValues = EnumSet.allOf(MetricStatistic.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MetricStatistic.class, MetricStatistic::toString);
    }
}

