/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apprunner.model.AppRunnerResponse;
import software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationSummary;
import software.amazon.awssdk.services.apprunner.model.ObservabilityConfigurationSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListObservabilityConfigurationsResponse
extends AppRunnerResponse
implements ToCopyableBuilder<Builder, ListObservabilityConfigurationsResponse> {
    private static final SdkField<List<ObservabilityConfigurationSummary>> OBSERVABILITY_CONFIGURATION_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ObservabilityConfigurationSummaryList").getter(ListObservabilityConfigurationsResponse.getter(ListObservabilityConfigurationsResponse::observabilityConfigurationSummaryList)).setter(ListObservabilityConfigurationsResponse.setter(Builder::observabilityConfigurationSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservabilityConfigurationSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ObservabilityConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListObservabilityConfigurationsResponse.getter(ListObservabilityConfigurationsResponse::nextToken)).setter(ListObservabilityConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBSERVABILITY_CONFIGURATION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListObservabilityConfigurationsResponse.memberNameToFieldInitializer();
    private final List<ObservabilityConfigurationSummary> observabilityConfigurationSummaryList;
    private final String nextToken;

    private ListObservabilityConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.observabilityConfigurationSummaryList = builder.observabilityConfigurationSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasObservabilityConfigurationSummaryList() {
        return this.observabilityConfigurationSummaryList != null && !(this.observabilityConfigurationSummaryList instanceof SdkAutoConstructList);
    }

    public final List<ObservabilityConfigurationSummary> observabilityConfigurationSummaryList() {
        return this.observabilityConfigurationSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObservabilityConfigurationSummaryList() ? this.observabilityConfigurationSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObservabilityConfigurationsResponse)) {
            return false;
        }
        ListObservabilityConfigurationsResponse other = (ListObservabilityConfigurationsResponse)((Object)obj);
        return this.hasObservabilityConfigurationSummaryList() == other.hasObservabilityConfigurationSummaryList() && Objects.equals(this.observabilityConfigurationSummaryList(), other.observabilityConfigurationSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListObservabilityConfigurationsResponse").add("ObservabilityConfigurationSummaryList", this.hasObservabilityConfigurationSummaryList() ? this.observabilityConfigurationSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObservabilityConfigurationSummaryList": {
                return Optional.ofNullable(clazz.cast(this.observabilityConfigurationSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ObservabilityConfigurationSummaryList", OBSERVABILITY_CONFIGURATION_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListObservabilityConfigurationsResponse, T> g) {
        return obj -> g.apply((ListObservabilityConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppRunnerResponse.BuilderImpl
    implements Builder {
        private List<ObservabilityConfigurationSummary> observabilityConfigurationSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObservabilityConfigurationsResponse model) {
            super(model);
            this.observabilityConfigurationSummaryList(model.observabilityConfigurationSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<ObservabilityConfigurationSummary.Builder> getObservabilityConfigurationSummaryList() {
            List<ObservabilityConfigurationSummary.Builder> result = ObservabilityConfigurationSummaryListCopier.copyToBuilder(this.observabilityConfigurationSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObservabilityConfigurationSummaryList(Collection<ObservabilityConfigurationSummary.BuilderImpl> observabilityConfigurationSummaryList) {
            this.observabilityConfigurationSummaryList = ObservabilityConfigurationSummaryListCopier.copyFromBuilder(observabilityConfigurationSummaryList);
        }

        @Override
        public final Builder observabilityConfigurationSummaryList(Collection<ObservabilityConfigurationSummary> observabilityConfigurationSummaryList) {
            this.observabilityConfigurationSummaryList = ObservabilityConfigurationSummaryListCopier.copy(observabilityConfigurationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder observabilityConfigurationSummaryList(ObservabilityConfigurationSummary ... observabilityConfigurationSummaryList) {
            this.observabilityConfigurationSummaryList(Arrays.asList(observabilityConfigurationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder observabilityConfigurationSummaryList(Consumer<ObservabilityConfigurationSummary.Builder> ... observabilityConfigurationSummaryList) {
            this.observabilityConfigurationSummaryList(Stream.of(observabilityConfigurationSummaryList).map(c -> (ObservabilityConfigurationSummary)((ObservabilityConfigurationSummary.Builder)ObservabilityConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListObservabilityConfigurationsResponse build() {
            return new ListObservabilityConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppRunnerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListObservabilityConfigurationsResponse> {
        public Builder observabilityConfigurationSummaryList(Collection<ObservabilityConfigurationSummary> var1);

        public Builder observabilityConfigurationSummaryList(ObservabilityConfigurationSummary ... var1);

        public Builder observabilityConfigurationSummaryList(Consumer<ObservabilityConfigurationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

