/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore;

import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.regions.Region;

@SdkPublicApi
public abstract class AwsServiceClientConfiguration
extends SdkServiceClientConfiguration {
    private final Region region;

    protected AwsServiceClientConfiguration(Builder builder) {
        super((SdkServiceClientConfiguration.Builder)builder);
        this.region = builder.region();
    }

    public Region region() {
        return this.region;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AwsServiceClientConfiguration serviceClientConfiguration = (AwsServiceClientConfiguration)((Object)o);
        return Objects.equals(this.region, serviceClientConfiguration.region);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
        return result;
    }

    protected static abstract class BuilderImpl
    implements Builder {
        protected ClientOverrideConfiguration overrideConfiguration;
        protected Region region;

        protected BuilderImpl() {
        }

        protected BuilderImpl(AwsServiceClientConfiguration awsServiceClientConfiguration) {
            this.overrideConfiguration = awsServiceClientConfiguration.overrideConfiguration();
            this.region = awsServiceClientConfiguration.region();
        }

        public Builder overrideConfiguration(ClientOverrideConfiguration clientOverrideConfiguration) {
            this.overrideConfiguration = clientOverrideConfiguration;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public final ClientOverrideConfiguration overrideConfiguration() {
            return this.overrideConfiguration;
        }

        @Override
        public final Region region() {
            return this.region;
        }
    }

    public static interface Builder
    extends SdkServiceClientConfiguration.Builder {
        public Region region();

        public Builder region(Region var1);

        public AwsServiceClientConfiguration build();
    }
}

